/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.biz.dao.app.AppBudgetDao;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.exception.StatusException;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBudgetServiceImpl
implements AppBudgetService {
    private static final Logger log = LoggerFactory.getLogger(AppBudgetServiceImpl.class);
    @Resource
    private AppBudgetDao appBudgetDao;
    @Resource
    private CacheClient memcachedClient;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void clearMonthBudget(Long appId) {
        this.appBudgetDao.clearMonthBudget(appId);
        this.removeCacheById(appId);
    }

    @Override
    public void cleanDayBudget(Long appId) {
        this.appBudgetDao.cleanDayBudget(appId);
        this.removeCacheById(appId);
    }

    @Override
    @Transactional(value="credits")
    public void deductBudget(Long appId, Integer actualPrice) throws StatusException {
        if (actualPrice > 0) {
            int rt;
            int ret;
            AppBudgetDto capp = this.getObject(appId);
            if (capp.getDayBudget() != null && (ret = this.appBudgetDao.deductBudgetDay(appId, actualPrice)) == 0) {
                throw new StatusException(4);
            }
            if (capp.getBudget() != null && (rt = this.appBudgetDao.deductBudgetMonth(appId, actualPrice)) == 0) {
                throw new StatusException(3);
            }
        }
        this.removeCacheById(appId);
    }

    @Override
    public boolean updateForDeveloperBack(AppBudgetDto budget) {
        AppBudgetDto capp = this.getObject(budget.getAppId());
        BigDecimal dayBudgetBD = null;
        Integer dayBudgetInt = null;
        if (budget.getDayBudget() != null) {
            dayBudgetBD = new BigDecimal(budget.getDayBudget());
            dayBudgetInt = dayBudgetBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue();
            if (!dayBudgetInt.equals(capp.getDayBudget())) {
                Integer remain = dayBudgetInt - (capp.getDayBudget() == null ? 0 : capp.getDayBudget()) + (capp.getDayBudgetRemain() == null ? 0 : capp.getDayBudgetRemain());
                capp.setDayBudgetRemain(Integer.valueOf(remain < 0 ? 0 : remain));
                capp.setDayBudget(dayBudgetInt);
            }
        } else {
            capp.setDayBudgetRemain(null);
            capp.setDayBudget(null);
        }
        BigDecimal monthBudgetBD = null;
        Integer monthBudgetInt = null;
        if (budget.getBudget() != null) {
            monthBudgetBD = new BigDecimal(budget.getBudget());
            monthBudgetInt = monthBudgetBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue();
            if (!monthBudgetInt.equals(capp.getBudget())) {
                Integer remain = monthBudgetInt - (capp.getBudget() == null ? 0 : capp.getBudget()) + (capp.getBudgetRemain() == null ? 0 : capp.getBudgetRemain());
                capp.setBudgetRemain(Integer.valueOf(remain < 0 ? 0 : remain));
                capp.setBudget(monthBudgetInt);
            }
        } else {
            capp.setBudgetRemain(null);
            capp.setBudget(null);
        }
        BigDecimal auditPricePerConsumerBD = new BigDecimal(budget.getAuditPricePerConsumer() == null ? 0 : budget.getAuditPricePerConsumer());
        capp.setAuditPricePerConsumer(Integer.valueOf(auditPricePerConsumerBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue()));
        this.appBudgetDao.updateForDeveloperBack(capp);
        this.removeCacheById(budget.getAppId());
        return true;
    }

    private void removeCacheById(Long id) {
        try {
            this.memcachedClient.remove(this.getAppIdKey(id));
            this.eventBus.post((Object)new AppUpdateEvent(id));
        }
        catch (Exception e) {
            log.error("App\u9884\u7b97\u6e05\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    private String getAppIdKey(Long id) {
        StringBuilder sb = new StringBuilder();
        sb.append("dcm_keyAppBudgetByAppId_").append(id);
        return sb.toString();
    }

    @Override
    public AppBudgetDto getObject(Long appId) {
        AppBudgetDto a = (AppBudgetDto)this.memcachedClient.get(this.getAppIdKey(appId));
        if (Objects.equals(null, a)) {
            a = this.appBudgetDao.find(appId);
            this.memcachedClient.set(this.getAppIdKey(appId), (Object)a, 300);
        }
        return a;
    }
}

