/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dao.app.AppExtraDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppExtraServiceImpl
implements AppExtraService {
    @Resource
    private AppExtraDao appExtraDao;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private BizEventBus eventBus;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void createAppListener(AppCreateEvent event) {
        AppDO app = event.getApp();
        AppExtraEntity entity = new AppExtraEntity(true);
        entity.setAppId(app.getId());
        this.insert(entity);
    }

    private String getSimpleCacheKeyByAppId(Long appId) {
        return "dcm_keyAppExtraSimpleByAppId1_" + appId;
    }

    private String getProgramCacheKeyByAppId(Long appId) {
        return "dcm_keyAppExtraProgramByAppId1_" + appId;
    }

    @Override
    public AppExtraEntity findByAppId(Long appId) {
        String key = this.getSimpleCacheKeyByAppId(appId);
        AppExtraEntity d = (AppExtraEntity)((Object)this.cacheClient.get(key));
        if (d == null) {
            d = this.appExtraDao.findByAppId(appId);
            this.cacheClient.set(key, (Object)d, 300);
        }
        return d;
    }

    @Override
    public AppExtraEntity findByAppIdIfNullAutoCreate(Long appId) {
        AppExtraEntity appExtra = this.findByAppId(appId);
        if (appExtra == null) {
            appExtra = new AppExtraEntity(true);
            appExtra.setAppId(appId);
            this.insert(appExtra);
            appExtra = this.findByAppId(appId);
        }
        return appExtra;
    }

    @Override
    public void insert(AppExtraEntity appExtraEntity) {
        this.appExtraDao.insert(appExtraEntity);
    }

    @Override
    public AppExtraEntity find(Long id) {
        return this.appExtraDao.find(id);
    }

    @Override
    public Integer update(AppExtraEntity appExtraEntity) {
        AppExtraEntity d;
        Long appId = appExtraEntity.getAppId();
        if (appId == null && (d = this.find(appExtraEntity.getId())) != null) {
            appId = d.getAppId();
        }
        Integer ret = this.appExtraDao.update(appExtraEntity);
        this.cacheClient.remove(this.getSimpleCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public void insertAppConfig(AppExtraEntity appExtraEntity) {
        this.appExtraDao.insertAppConfig(appExtraEntity);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc, String callLoginProgram) {
        Integer ret = this.appExtraDao.updateAppConfig(appId, entranceDesc, callLoginProgram);
        this.cacheClient.remove(this.getSimpleCacheKeyByAppId(appId));
        this.cacheClient.remove(this.getProgramCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        String key = this.getProgramCacheKeyByAppId(appId);
        String ret = (String)this.cacheClient.get(key);
        if (ret == null) {
            ret = this.appExtraDao.findCallLoginProgramByAppId(appId);
            this.cacheClient.set(key, (Object)ret, 300);
        }
        return ret;
    }

    @Override
    public List<AppExtraEntity> findByAppIds(List<Long> appIds) {
        return this.appExtraDao.findByAppIds(appIds);
    }

    @Override
    public int updateAppPerson(Long appId, String appPerson) {
        return this.appExtraDao.updateAppPerson(appId, appPerson);
    }

    @Override
    public List<Long> findByAppPerson(String name) {
        return this.appExtraDao.findByAppPerson(name);
    }

    @Override
    public int updateAddCreditsUrl(Long appId, String addCreditsUrl) {
        int ret = this.appExtraDao.updateAddCreditsUrl(appId, addCreditsUrl);
        this.cacheClient.remove(this.getSimpleCacheKeyByAppId(appId));
        this.cacheClient.remove(this.getProgramCacheKeyByAppId(appId));
        return ret;
    }
}

