/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.dao.developer.DeveloperDao;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DeveloperServiceImpl
implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "dcm_keyDeveloperId_" + id;
    }

    @Override
    public void insertDeveloper(DeveloperEntity developer) {
        this.developerDao.insert(developer);
    }

    @Override
    public DeveloperEntity findByEmail(String email) {
        return this.developerDao.findByEmail(email);
    }

    @Override
    public DeveloperEntity find(Long id) {
        DeveloperEntity d = (DeveloperEntity)((Object)this.cacheClient.get(this.getCacheKeyById(id)));
        if (d == null) {
            d = this.developerDao.find(id);
            this.cacheClient.set(this.getCacheKeyById(id), (Object)d, 300);
        }
        return d;
    }

    @Override
    public List<DeveloperEntity> findByEmailLike(String email) {
        return this.developerDao.findByEmailLike(email);
    }

    @Override
    public List<DeveloperEntity> findAllByIdList(Collection<Long> idList) {
        if (idList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.developerDao.findAllByIdList(new ArrayList<Long>(idList));
    }

    @Override
    public List<Long> findAllEnbleId() {
        return this.developerDao.findAllEnbleId();
    }

    @Override
    public List<DeveloperEntity> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPage(queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPageCount(queryEntity);
    }

    @Override
    public int updateDeveloperSwitch(SwitchTool tool) {
        int ret = this.developerDao.updateDeveloperSwitch(tool.getId(), tool.getSwicthValue());
        this.cacheClient.remove(this.getCacheKeyById(tool.getId()));
        return ret;
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        int ret = this.developerDao.updateLastRemindTime(id, lastRemindTime);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        int ret = this.developerDao.updateRemindMoneyNameCompany(id, remindMoney, name, company);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updatePassword(Long id, String password) {
        int ret = this.developerDao.updatePassword(id, password);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        int ret = this.developerDao.updateVerifyAndEnable(id, verify, enable);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateJson(Long id, String jsonStr) {
        return this.developerDao.updateJson(id, jsonStr);
    }
}

