package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * Created by liuyao on 16/7/28.
 */
public interface AppLayoutBo {

    PaginationVO<AppLayoutBrickDto> getSystemThemeLayoutPage(PageQueryEntity params);

    PaginationVO<AppLayoutBrickDto> getCustomThemeLayoutPage(PageQueryEntity params);

    AppLayoutDto getObject(Long appId);

    void updateThemeColor(Long appId, String color) throws BusinessException;

    void devSetSkin(Long appId, Long skinId) throws BusinessException;

    void devReSetFloorList(Long appId, JSONArray floorSortList) throws BusinessException;

    Integer updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig) throws BusinessException;
}
