package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.WithdrawCashParams;
import cn.com.duiba.developer.center.biz.bo.DevWithdrawCashBo;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import java.math.BigDecimal;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class DevWithdrawCashBoImpl implements DevWithdrawCashBo {

    @Autowired
    private PlatformTransactionManager           creditsTransactionManager;

    @Autowired
    private AmbDeveloperWithdrawCashAuditService ambDeveloperWithdrawCashAuditService;

    @Autowired
    private AmbDeveloperWithdrawCashOrderService ambDeveloperWithdrawCashOrderService;

    @Override
    public DubboResult<Tuple.Tuple2<AmbDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashOrderDto>> firstWithdrawToBankOrAlipay(WithdrawCashParams withdrawCashParams) throws Exception {
        AmbDeveloperWithdrawCashAuditDto cashAuditDO = null;
        AmbDeveloperWithdrawCashOrderDto cashOrderDO = null;
        // 提现到银行或支付宝,需要审核
        // 如果有正在审核的，则拒绝再次申请
        TransactionStatus transaction = creditsTransactionManager.getTransaction(new DefaultTransactionDefinition());
        try {
            AmbDeveloperWithdrawCashAuditDto auditing = ambDeveloperWithdrawCashAuditService.findAuditing(withdrawCashParams.getDeveloperId(),
                                                                                                          withdrawCashParams.getCashType());
            if (auditing != null) {
                throw new BusinessException("该提现方式已经存在审核中的申请，不能重复申请！");
            }
            // 有申请提交，则将旧的审核信息置为失效
            ambDeveloperWithdrawCashAuditService.disableValidPassAudit(withdrawCashParams.getDeveloperId(),
                                                                       withdrawCashParams.getCashType());
            cashAuditDO = new AmbDeveloperWithdrawCashAuditDto(true);
            cashAuditDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashAuditDO.setCashType(withdrawCashParams.getCashType());
            cashAuditDO.setBusinessLicencePic(withdrawCashParams.getBusinessLicencePic());
            cashAuditDO.setIdCardFrontPic(withdrawCashParams.getIdCardFrontPic());
            cashAuditDO.setIdCardBackPic(withdrawCashParams.getIdCardBackPic());
            cashAuditDO.setBank(withdrawCashParams.getBank());
            cashAuditDO.setBankProvince(withdrawCashParams.getBankProvince());
            cashAuditDO.setBankCity(withdrawCashParams.getBankCity());
            cashAuditDO.setBankBranchName(withdrawCashParams.getBankBranchName());
            cashAuditDO.setBankAccountNumber(withdrawCashParams.getBankAccountNumber());
            cashAuditDO.setBankAccountName(withdrawCashParams.getBankAccountName());
            cashAuditDO.setAlipayAccountName(withdrawCashParams.getAlipayAccountName());
            cashAuditDO.setAlipayAccountNumber(withdrawCashParams.getAlipayAccountNumber());
            cashAuditDO.setStatus(AmbDeveloperWithdrawCashAuditDto.StatusCreate);
            cashAuditDO.setRegisterEmail(withdrawCashParams.getRegisterEmail());
            cashAuditDO.setPhone(withdrawCashParams.getPhone());
            ambDeveloperWithdrawCashAuditService.insert(cashAuditDO);

            cashOrderDO = new AmbDeveloperWithdrawCashOrderDto(true);
            cashOrderDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashOrderDO.setMoney(new BigDecimal("100").multiply(new BigDecimal(withdrawCashParams.getMoney())).longValue());
            cashOrderDO.setStatus(AmbDeveloperWithdrawCashOrderDto.StatusCreate);
            cashOrderDO.setRequiredAudit(true);
            cashOrderDO.setAuditId(cashAuditDO.getId());

            if (AmbDeveloperWithdrawCashAuditDto.CashTypeAliPay.equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("提现到支付宝：" + cashAuditDO.getAlipayAccountNumber());
            } else if (AmbDeveloperWithdrawCashAuditDto.CashTypeBank.equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("提现到银行卡：" + cashAuditDO.getBankAccountNumber());
            }
            ambDeveloperWithdrawCashOrderService.insert(cashOrderDO);

        } catch (Exception e) {
            transaction.setRollbackOnly();
            throw e;
        } finally {
            creditsTransactionManager.commit(transaction);
        }
        return DubboResult.successResult(Tuple.tuple(cashAuditDO, cashOrderDO));
    }

    @Override
    public void updateAuditAndOrderStatus(AmbDeveloperWithdrawCashAuditDto cashAuditDO,
                                          AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        TransactionStatus transactionA = creditsTransactionManager.getTransaction(new DefaultTransactionDefinition());
        try {
            // 支付成功，更改提现状态为待处理
            ambDeveloperWithdrawCashOrderService.updateStatusCreateToWaitPay(cashOrderDO.getId());
            // 更改审核信息状态为待审核
            ambDeveloperWithdrawCashAuditService.updateStatusCreateToWait(cashAuditDO.getId());
        } catch (Exception e) {
            transactionA.setRollbackOnly();
            throw e;
        } finally {
            creditsTransactionManager.commit(transactionA);
        }
    }
}
