/**
 * Project Name:developer-center-biz
 * File Name:AppTagsMaskingDto.java
 * Package Name:cn.com.duiba.developer.center.biz.dao.app
 * Date:2016年8月16日上午10:26:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.biz.dao.app;

import java.util.List;

import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;

/**
 * ClassName:AppTagsMaskingDto <br/>
 * Date:     2016年8月16日 上午10:26:36 <br/>
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface AppTagsMaskingDao {
    /**
     * 屏蔽该标签的APP数
     * @param tagsId
     * @return
     */
    public Integer countByTagsId(Long tagsId);
    
    /**
     *  根据TagsId查询
     * @param tagsId
     * @return
     */
    public List<AppTagsMaskingEntity> findAllByTagsId(Long tagsId);
    
    /**
     * 根据tagsId删除
     * @param tagsId
     */
    public void deleteByTagsId(Long tagsId);
    
    
    public List<Long> findTagIdsByAppId(Long appId);
    
    public void deleteByAppId(Long appId);
    
    public void insert(AppTagsMaskingEntity appTagsMaskingDO);
    
    public AppTagsMaskingEntity find(Long id);
    
    public void update(AppTagsMaskingEntity appTagsMaskingDO);
}

