/**
 * Project Name:developer-center-biz File Name:AppBannerDaoImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.dao.app.impl Date:2016年8月10日下午7:25:58 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.dao.app.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.app.AppBannerDao;
import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

/**
 * ClassName:AppBannerDaoImpl <br/>
 * Date: 2016年8月10日 下午7:25:58 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository
public class AppBannerDaoImpl extends BaseDao implements AppBannerDao {

    @Override
    public AppBannerEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public Integer updateByIdAndAppId(AppBannerEntity appBanner) {
        return update("updateByIdAndAppId", appBanner);
    }

    @Override
    public void insert(AppBannerEntity appBanner) {
        insert("insert", appBanner);
    }

    @Override
    public Integer findMaxPlayload(Long appId, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("type", type);
        return selectOne("findMaxPlayload", map);
    }

    @Override
    public List<AppBannerEntity> findAllByAppId(Long appId, Boolean deleted) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("deleted", deleted);
        return selectList("findAllByAppId", map);
    }

    @Override
    public List<AppBannerEntity> findListBetweenPayload(Long appId, String type, Integer startPayload,
                                                        Integer endPayload) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("type", type);
        if (startPayload < endPayload) {
            map.put("start", startPayload);
            map.put("end", endPayload);
        } else {
            map.put("start", endPayload);
            map.put("end", startPayload);
        }
        return selectList("findListBetweenPayload", map);
    }

    @Override
    public List<AppBannerEntity> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("type", type);
        map.put("deleted", deleted);
        return selectList("findAllByAppIdDeleteAndType", map);
    }

    @Override
    public List<AppBannerEntity> findBannerByItemId(Long appId, Long appItemId, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("appItemId", appItemId);
        map.put("type", type);
        return selectList("findBannerByItemId", map);
    }
}
