package cn.com.duiba.developer.center.biz.dao.developer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.developer.ExpressTemplateDao;
import cn.com.duiba.developer.center.biz.entity.AmbExpressTemplateEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

@Repository
public class ExpressTemplateDaoImpl extends BaseDao implements ExpressTemplateDao{

	@Override
	public AmbExpressTemplateEntity select(Long id) {
		return selectOne(("find"), id);
	}

	@Override
	public void insert(AmbExpressTemplateEntity entity) {
		insert(("insert"), entity);
	}

	@Override
	public int update(AmbExpressTemplateEntity entity) {
		return update(("update"),entity);
	}

	@Override
	public List<AmbExpressTemplateEntity> selectPageList(
			Map<String, Object> params) {
		return selectList(("findPageList"), params);
	}

	@Override
	public long selectPageCount(Map<String, Object> params) {
		return selectOne(("findPageCount"), params);
	}

	@Override
	public void deleteTemplateById(Long id) {
		update(("deleteTemplateById"),id);
	}

	@Override
	public List<AmbExpressTemplateEntity> selectByAppIdAndType(Long appId,
			String type) {
		Map<String, Object> params = new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("type", type);
        return selectList(("findByAppIdAndType"), params);
	}

	@Override
	public AmbExpressTemplateEntity selectByAppIdAndName(Long appId, String name) {
		Map<String, Object> params = new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("name", name);
        return selectOne(("findByAppIdAndName"), params);
	}

}
