package cn.com.duiba.developer.center.biz.dao.developer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.developer.SupplierProductsDao;
import cn.com.duiba.developer.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;
@Repository
public class SupplierProductsDaoImpl extends BaseDao implements SupplierProductsDao {

	@Override
	public SupplierProductEntity selectBySupplier(String supplier) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		return selectOne("selectBySupplier", map);
	}

	@Override
	public List<SupplierProductEntity> selectAllBySupplier(String supplier) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		return selectList("selectAllBySupplier", map);
	}

	@Override
	public SupplierProductEntity selectBySupplierAndProductId(String supplier,
			String productId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		map.put("productId", productId);
		return selectOne("selectBySupplierAndProductId", map);
	}

	@Override
	public List<SupplierProductEntity> selectBySupplierAndFacePrice(String supplier,
			Integer facePrice) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		map.put("facePrice", facePrice);
		return selectList("selectBySupplierAndFacePrice", map);
	}

	@Override
	public List<SupplierProductEntity> selectBySupplierAndMobileAndProvince(
			String supplier, String mobile, String province) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		map.put("mobile", mobile);
		map.put("province", province);
		return selectList("selectBySupplierAndMobileAndProvince", map);
	}

	@Override
	public List<SupplierProductEntity> selectAllBySupplierOrderByNameAndFacePrice(
			String supplier) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		return selectList("selectAllBySupplierOrderByNameAndFacePrice", map);
	}

	@Override
	public List<SupplierProductEntity> selectAllBySupplierOrderByProvinceAndFacePrice(
			String supplier) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		return selectList("selectAllBySupplierOrderByProvinceAndFacePrice", map);
	}

	@Override
	public List<SupplierProductEntity> selectAllBySupplierAndGameId(String supplier,
			String gameId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("supplier", supplier);
		map.put("gameId", gameId);
		return selectList("selectAllBySupplierAndGameId", map);
	}

	@Override
	public List<SupplierProductEntity> selectAllByIds(List<Long> ids) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("ids", ids);
		return selectList("selectAllByIds", map);
	}

	@Override
	public void insert(SupplierProductEntity SupplierProductEntity) {
		insert("insert", SupplierProductEntity);
	}

	@Override
	public void update(SupplierProductEntity SupplierProductEntity) {
		update("update", SupplierProductEntity);
	}

	@Override
	public SupplierProductEntity select(Long id) {
		return selectOne("select", id);
	}

}
