package cn.com.duiba.developer.center.biz.dao.floor;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;

/**
 * 楼层橱窗
 *<br/>
 * Author：zhengjy <br/>
 * Create Time：2016年10月14日 上午10:51:33
 */
public interface CreditsFloorShowcaseDao {
	/**
     * 根据appId和对应橱窗位编号查询橱窗位内容
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    FloorShowcaseContentDto selectShowcaseContent(long appId, int place);
    /**
     * 根据appId查询所有橱窗位内容
     *
     * @param appId 应用ID
     * @return
     */
	List<FloorShowcaseContentDto> selectShowcaseList(long appId);

    /**
     * 保存橱窗配置
     * @param showcaseEntity
     */
    void saveShowcaseConfig(ShowcaseEntity showcaseEntity);

    /**
     * 删除橱窗位
     * @param appId
     * @param place
     */
    void delShowcaseConfig(Long appId,Integer place);

    /**
     * 更新橱窗位配置
     * @param showcaseEntity
     */
    void updateShowcaseConfig(ShowcaseEntity showcaseEntity);

    /**
     * 根据appId和橱窗位置查询橱窗内容(忽略开启和关闭状态)
     * @param appId
     * @param place
     * @return
     */
    FloorShowcaseContentDto getShowcaseContentIgnoreStatus(long appId, int place);
}
