package cn.com.duiba.developer.center.biz.remoteservice.floor;

import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.biz.remoteservice.impl.RemoteAppBannerServiceNewImpl;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteAppLayoutService;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/27.
 */
@Service
public class RemoteAppLayoutServiceImpl implements RemoteAppLayoutService {

    private static Logger    logger = LoggerFactory.getLogger(RemoteAppBannerServiceNewImpl.class);

    @Autowired
    private AppLayoutBo      appLayoutBo;

    @Autowired
    private AppLayoutService appLayoutService;

    @Override
    public DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params) {

        return DubboResult.successResult(appLayoutBo.getSystemThemeLayoutPage(params));
    }

    @Override
    public DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params) {
        return DubboResult.successResult(appLayoutBo.getCustomThemeLayoutPage(params));
    }

    @Override
    public DubboResult<Boolean> updateThemeColor(Long appId, String color) {
        try {
            appLayoutBo.updateThemeColor(appId, color);
            return DubboResult.successResult(true);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }

    }

    @Override
    public DubboResult<Boolean> devSetSkin(Long appId, Long skinId) {
        try {
            appLayoutBo.devSetSkin(appId, skinId);
            return DubboResult.successResult(true);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> devReSetFloorList(Long appId, JSONArray floorSortList) {
        try {
            appLayoutBo.devReSetFloorList(appId, floorSortList);
            return DubboResult.successResult(true);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig) {
        try {

            Integer ret = appLayoutBo.updateDevFloorConfigByAppId(appId, floorId,floorConfig);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            AppLogUtil.error(logger, "invoke updateDevFloorConfigByAppId failed, appId={}, floorId={}, floorConfig={}",
                             appId, floorId, floorConfig, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<AppLayoutDto> getAppLayout(Long appId) {
        return DubboResult.successResult(appLayoutBo.getObject(appId));
    }

    @Override
    public DubboResult<Integer> getSkinType(Long appId) {
        try{
            AppLayoutDto dto = appLayoutBo.getObject(appId);
            if(dto==null) throw new BusinessException("app无效");
            return DubboResult.successResult(dto.getSkinType().intValue());
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }
}
