package cn.com.duiba.developer.center.biz.remoteservice.floor;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteCreditsFloorSkinService;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteCreditsFloorSkinServiceImpl implements RemoteCreditsFloorSkinService {

    private static final Logger logger = LoggerFactory.getLogger(RemoteCreditsFloorSkinServiceImpl.class);

    @Autowired
    private FloorBo floorBo;

    @Autowired
    private CreditsFloorSkinService creditsFloorSkinService;


    @Override
    public DubboResult<PaginationVO<JSONObject>> getSkinPage(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page = floorBo.getSkinPage(params);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<CreditsFloorSkinDto> insertFloorSkin(CreditsFloorSkinDto dto) {
        try {
            ValidatorTool.valid(dto);
            dto = floorBo.insertFloorSkin(Optional.of(dto));
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            logger.error("创建楼层皮肤失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateFloorSkin(CreditsFloorSkinDto dto) {
        try {
            ValidatorTool.valid(dto);
            int ret = floorBo.updateFloorSkin(Optional.of(dto));
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            logger.error("更新楼层皮肤失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PaginationVO<JSONObject>> selectFloorSkins(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page = floorBo.getSkinPage(params);
            return DubboResult.successResult(page);
        }catch (Exception e){
            logger.error("", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<CreditsFloorSkinDto> selectFloorSkinById(Long id) {
        try {
            CreditsFloorSkinDto dto=creditsFloorSkinService.selectFloorSkinById(id);
            return DubboResult.successResult(dto);
        }catch (Exception e){
            logger.error("",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<JSONObject> getOneSkinConfig(Long id) {
        try{
            JSONObject json = floorBo.getOneSkinConfig(id);
            return DubboResult.successResult(json);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> switchSkinSpecify(Long id, Boolean isOpen) {
        try{
            return DubboResult.successResult(floorBo.switchSkinSpecify(id,isOpen));
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AppSimpleDto>> getSpecifyAppList(Long skinId) {
        return DubboResult.successResult(floorBo.findAppSpecifyList(skinId));
    }

    @Override
    public DubboResult<Boolean> addAppSpecify(Long skinId, Long appId) {
        try{
            return DubboResult.successResult(floorBo.addAppSpecify(appId,skinId));
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> switchOpenState(Long skinId, Boolean isOpen) {
        return DubboResult.successResult(creditsFloorSkinService.switchOpenState(skinId,isOpen));
    }

    @Override
    public DubboResult<List<JSONObject>> loadDevSkinList(Long appId) {
        try{
            return DubboResult.successResult(floorBo.loadDevSkinList(appId));
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

}
