package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AerosolDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAerosolService;
import cn.com.duiba.developer.center.biz.bo.AerosolBo;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;

import javax.ws.rs.HEAD;
import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 16/9/8.
 */
@Service
public class RemoteAerosolServiceImpl implements RemoteAerosolService {

    @Autowired
    private AerosolBo aerosolBo;

    @Override
    public DubboResult<AerosolDto> loadAerosolConfig(Long appId) {
        return DubboResult.successResult(aerosolBo.getAerosolDto(appId));

    }

    @Override
    public DubboResult<AerosolDto> loadAerosolNoCache(Long appId) {
        return DubboResult.successResult(aerosolBo.loadAerosolNoCache(appId));
    }

    @Override
    public DubboResult<List<AerosolGroupDto>> loadAerosolGroup() {
        return DubboResult.successResult(aerosolBo.loadAerosolGroup());
    }

    @Override
    public DubboResult<Long> createAerosolGroup(AerosolGroupDto groupDto){
        try{
            ValidatorTool.valid(groupDto);
            return DubboResult.successResult( aerosolBo.createAerosolGroup(groupDto));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteAerosolGroup(Long id){
        try {
            aerosolBo.deleteAerosolGroup(id);
            return  DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }



    @Override
    public DubboResult<Boolean> addToGroup(Long groupId, Long appId) {
        try{
            aerosolBo.addToGroup(groupId,appId);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> batchAddToGroup(Long groupId, Set<Long> appIds) {
        try{
            aerosolBo.batchAddToGroup(groupId,appIds);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delForGroup(Long appId){
        try{
            aerosolBo.delForGroup(appId);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> synAerosolGroup(Long groupId,Set<Long> igenoreIds){
        try{
            aerosolBo.synAerosolGroup(groupId,igenoreIds);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delAerosolByGroupId(Long groupId,Set<Long> igenoreIds){
        try{
            aerosolBo.delAerosolByGroupId(groupId, igenoreIds);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delAerosolByAppId(Long appId){
        try{
            aerosolBo.delAerosolByAppId(appId);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> createAerosol(AerosolDto config){
        try{
            ValidatorTool.valid(config);
            aerosolBo.createAerosol(config);
            return DubboResult.successResult(true);
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }
    @Override
    public DubboResult<AerosolGroupDto> getAerosolGroupById(Long groupId){
        try{
            return DubboResult.successResult(aerosolBo.getAerosolGroupById(groupId));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateAerosolGroupShowStatus(Long groupId){
        try{
            return DubboResult.successResult(aerosolBo.updateAerosolGroupShowStatus(groupId));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateAerosolShowStatus(Long appId) {
        try{
            return DubboResult.successResult(aerosolBo.updateAerosolShowStatus(appId));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateAerosol(AerosolDto config) {
        try{
            ValidatorTool.valid(config);
            aerosolBo.updateAerosol(config);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }


    @Override
    public DubboResult<List<AerosolDto>> loadGroupAppList(Long groupId){
        try {
            return DubboResult.successResult(aerosolBo.loadGroupAppList(groupId));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }
    
    public DubboResult<Boolean> updateGroupConfig(AerosolGroupDto aerosolGroupDto){
        try {
            ValidatorTool.valid(aerosolGroupDto);
            return DubboResult.successResult(aerosolBo.updateGroupConfig(aerosolGroupDto));
        }catch (BusinessException e){
          return  DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<PaginationVO<AerosolDto>> loadAerosolList(AppAerosolParams entity){
        try{
            return DubboResult.successResult(aerosolBo.loadAerosolPage(entity));
        }catch (BusinessException e){
            return  DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AerosolDto>> loadAerosolByAppIds(Set<Long> appIds) {
        try{
            return DubboResult.successResult(aerosolBo.loadAerosolByAppIds(appIds));
        }catch (BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }
}
