package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class RemoteAmbDeveloperWithdrawCashAuditServiceImpl implements RemoteAmbDeveloperWithdrawCashAuditService {

    @Autowired
    private AmbDeveloperWithdrawCashAuditService ambDeveloperWithdrawCashAuditService;

    @Override
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> insert(AmbDeveloperWithdrawCashAuditDto ambDeveloperWithdrawCashAuditDto) {
        ambDeveloperWithdrawCashAuditService.insert(ambDeveloperWithdrawCashAuditDto);
        return DubboResult.successResult(ambDeveloperWithdrawCashAuditDto);
    }

    @Override
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findById(Long id) {
        return DubboResult.successResult(ambDeveloperWithdrawCashAuditService.findById(id));
    }

    @Override
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findValidPassAudit(Long developerId, String cashType) {
        return DubboResult.successResult(ambDeveloperWithdrawCashAuditService.findValidPassAudit(developerId, cashType));
    }

    @Override
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findAuditing(Long developerId, String cashType) {
        return DubboResult.successResult(ambDeveloperWithdrawCashAuditService.findAuditing(developerId, cashType));
    }

    @Override
    public void disableValidPassAudit(Long developerId, String cashType) {
        ambDeveloperWithdrawCashAuditService.disableValidPassAudit(developerId, cashType);
    }

    @Override
    public int updateStatusCreateToWait(Long auditId) {
        return ambDeveloperWithdrawCashAuditService.updateStatusCreateToWait(auditId);
    }

    @Override
    public DubboResult<List<AmbDeveloperWithdrawCashAuditDto>> findByIds(List<Long> auditIds) {
        return DubboResult.successResult(ambDeveloperWithdrawCashAuditService.findByIds(auditIds));
    }
}
