package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.remoteservice.RemoteAppExtraService;
import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 * Created by liuyao on 2016/10/12.
 */
@Service
public class RemoteAppExtraServiceImpl implements RemoteAppExtraService {
    @Autowired
    private AppExtraService appExtraService;

    @Override
    public DubboResult<String> findAppAddCreditsUrlByAppId(Long appId) {
        AppExtraEntity entity = appExtraService.findByAppId(appId);
        if(entity==null){
            return DubboResult.successResult("");
        }
        return DubboResult.successResult(StringUtils.trimToEmpty(entity.getAddCreditsUrl()));
    }
}
