package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;

import com.google.common.base.Objects;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.RemoteInternalLetterService;
import cn.com.duiba.developer.center.biz.bo.InternalLetterBo;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class RemoteInternalLetterServiceImpl implements RemoteInternalLetterService {

    @Autowired
    private InternalLetterBo internalLetterBo;

    @Override
    public DubboResult<Boolean> saveInternalLetter(InternalLetterDO letter) {
        try {
            ValidatorTool.valid(letter);
            internalLetterBo.submitInternalLetter(Optional.of(letter));
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteInternalLetter(Long letterId) {
        try {
            internalLetterBo.deleteInternalLette(letterId);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteInternalLetter(Long developerId, Long letterId) {
        try {
            internalLetterBo.deleteInternalLette(developerId,letterId);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<InternalLetterDO> getOneInternalLetter(Long letterId) {
        return DubboResult.successResult(internalLetterBo.find(letterId));
    }

    @Override
    public DubboResult<PaginationVO<InternalLetterDO>> getInternalLetterPage(InternalLetterQueryEntity param) {
        return DubboResult.successResult(internalLetterBo.getInternalLetterPage(param));
    }

    @Override
    public DubboResult<PaginationVO<InternalLetterKeyDO>> getInternalLetterKeyPage(InternalLetterQueryEntity param) {
        if(Objects.equal(null,param.getDeveloperId())){
            return DubboResult.failResult("加载开发者站内信列表必须指定开发者Id号");
        }

        PaginationVO<InternalLetterKeyDO> page = internalLetterBo.getInternalLetterKeyPage(param);

        return DubboResult.successResult(page);
    }

    @Override
    public DubboResult<Integer> setAllReaded(Long developerId){
        return DubboResult.successResult(internalLetterBo.setAllReaded(developerId));
    }

    @Override
    public DubboResult<InternalLetterDO> developerFindInternalLetter(Long developerId, Long letterId) {
        return DubboResult.successResult(internalLetterBo.developerFindInternalLetter(developerId,letterId));
    }

    @Override
    public DubboResult<Integer> getNoRead(Long developerId) {
        return DubboResult.successResult(internalLetterBo.getNoRead(developerId));
    }
}
