package cn.com.duiba.developer.center.biz.remoteservice.statistics;

import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemDwmStatDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemWeekMonthStatDto;
import cn.com.duiba.developer.center.api.remoteservice.statistics.RemoteOdpsAppItemDwmStatService;
import cn.com.duiba.developer.center.biz.service.statistics.OdpsAppItemDwmStatService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/8/2.
 */
@Service
public class RemoteOdpsAppItemDwmStatServiceImpl implements RemoteOdpsAppItemDwmStatService {
    @Resource
    private OdpsAppItemDwmStatService odpsAppItemDwmStatService;

    @Override
    public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay) {
        return DubboResult.successResult(odpsAppItemDwmStatService.findSumByAppIdAndDayBetween(appId, startDay, endDay));
    }

    @Override
    public DubboResult<OdpsAppItemWeekMonthStatDto> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, Long relationId, Integer relationType) {
        return DubboResult.successResult(odpsAppItemDwmStatService.findWeekAndMonthByAppIdAndDay(appId, startDay, endDay, relationId, relationType));
    }

    @Override
    public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayAndOrderBy(Map<String, Object> params) {
        return DubboResult.successResult(odpsAppItemDwmStatService.findSumByAppIdAndDayAndOrderBy(params));
    }

    @Override
    public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayAndIdAndTypeAndOrderBy(Map<String, Object> params) {
        return DubboResult.successResult(odpsAppItemDwmStatService.findSumByAppIdAndDayAndIdAndTypeAndOrderBy(params));
    }

    @Override
    public DubboResult<List<OdpsAppItemWeekMonthStatDto>> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, List<Long> relationIds, Integer relationType) {
        return DubboResult.successResult(odpsAppItemDwmStatService.findWeekAndMonthByAppIdAndDay(appId, startDay, endDay, relationIds, relationType));
    }
}
