package cn.com.duiba.developer.center.biz.service.credits;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.common.tools.SwitchTool;

/**
 * Created by liuyao on 16/7/18.
 */
public interface DeveloperService {
    /**
     * @author houwen
     * @Description: 添加开发者初始化账户保证事务
     * @param developer
     *            开发者信息
     */
    void insertDeveloper(DeveloperEntity developer);


    DeveloperEntity findByEmail(String email);

    DeveloperEntity find(Long id);

    /**
     * 根据email模糊查询
     */
    List<DeveloperEntity> findByEmailLike(String email);

    List<DeveloperEntity> findAllByIdList(Collection<Long> ids);

    List<Long> findAllEnbleId();

    /**
     * 管理员后台开发者分页
     */
    List<DeveloperEntity> findDeveloperPage(ADeveloperQueryEntity queryEntity);

    /**
     * 管理员后台开发者列表总数
     */
    Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity);

    int updateDeveloperSwitch(SwitchTool tool);

    int updateLastRemindTime(Long id, Date lastRemindTime);

    int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company);

    int updatePassword(Long id, String password);

    int updateVerifyAndEnable(Long id, boolean verify, boolean enable);

    int updateJson(Long id,String jsonStr);
}
