package cn.com.duiba.developer.center.biz.service.credits;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.google.common.eventbus.Subscribe;

import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.biz.dao.developer.RemainingMoneyDao;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.event.DeveloperCreateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.utils.SecurityUtils;

/**
 * Created by liuyao on 2016/10/11.
 */
@Service
public class RemainingMoneyService {
    @Autowired
    private BizEventBus eventBus;
    /**
     * 签名私钥
     */
    @Value("${dcm.balance.key}")
    private String privateKey;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;

    @PostConstruct
    public void init(){
        eventBus.register(this);
    }

    @Subscribe
    public void initDeveloperRemainingMoneyListener(DeveloperCreateEvent event){

        DeveloperEntity developer = event.getDeveloper();

        RemainingMoneyDto rm = new RemainingMoneyDto(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(0);
        rm.setVersion(0L);
        /**
         * 设置余额签名(余额+版本号+变更时间)
         */
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5(privateKey + newMoney.toString() + newVersion + newModifedStr);
        rm.setSign(newSign);
        remainingMoneyDao.insert(rm);
    }
}
