/**
 * Project Name:developer-center-biz File Name:TagsService.java Package
 * Name:cn.com.duiba.developer.center.biz.service.credits Date:2016年8月16日上午10:48:05 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.service.credits;

import java.util.List;

import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;
import cn.com.duiba.developer.center.biz.entity.TagEntity;

/**
 * ClassName:TagsService <br/>
 * 标签相关服务 <br/>
 * Date: 2016年8月16日 上午10:48:05 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public interface TagsService {

    /**
     * 查询所有标签
     *
     * @author zhanglihui
     * @return
     * @since JDK 1.6
     */
    List<TagEntity> findAllTags();

    /**
     * 根据appId查询屏蔽标签id
     *
     * @author zhanglihui
     * @param appId
     * @return
     * @since JDK 1.6
     */
    List<Long> findShieldTagsByAppId(Long appId);

    void deleteTagMaskingByAppId(Long appId);

    void insertTagMasking(AppTagsMaskingEntity appTagsMaskingEntity);
}
