package cn.com.duiba.developer.center.biz.service.credits.floor;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;

/**
 * 楼层橱窗
 *<br/>
 * Author：zhengjy <br/>
 * Create Time：2016年10月14日 上午10:50:44
 */
public interface CreditsFloorShowcaseService {
	/**
     * 根据appId和对应橱窗位编号查询橱窗位内容
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    FloorShowcaseContentDto getShowcaseContent(long appId, int place);
    /**
     * 根据appId和对应橱窗位编号查询橱窗位内容(忽略橱窗位开启和关闭)
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    FloorShowcaseContentDto getShowcaseContentIgnoreStatus(long appId, int place);
    /**
     * 根据appId查询所有橱窗位内容
     *
     * @param appId 应用ID
     * @return
     */
	List<FloorShowcaseContentDto> getShowcaseList(long appId);

    /**
     * 保存橱窗配置
     * @param showcaseEntity
     */
    void saveShowcaseConfig(ShowcaseEntity showcaseEntity);

    /**
     * 删除橱窗位
     * @param appId
     * @param place
     */
    void delShowcaseConfig(Long appId,Integer place);

    /**
     * 更新橱窗位配置
     * @param showcaseEntity
     */
    void updateShowcaseConfig(ShowcaseEntity showcaseEntity);
}
