package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import static cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto.Skin_Type_Floor_Skin;
import static cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto.Skin_Type_Old_Theme;
import static cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutDao;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.biz.service.credits.floor.AppLayoutService;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.*;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;

@Service
public class AppLayoutServiceImpl implements AppLayoutService {
    private static final Logger log= LoggerFactory.getLogger(AppLayoutServiceImpl.class);
    /**
     * 维护楼层类型与该楼层对应JSON配置类型的关系,如果对应类型为BaseJson,说明该楼层类型没有配置
     */
    private static final Map<Integer,Class<? extends BaseJson>> floorJsonMap = Maps.newHashMap();
    static {
        floorJsonMap.put( CREDITS_FLOOR_TYPE_BANNER, BannerJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_ICON,IconJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_GOODS,GoodsJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_ROB,SnapUpJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_PAGE,ActivityJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_COUPON,CouponJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_FLOOR_BYSELF,BaseJson.class);
        floorJsonMap.put( CREDITS_FLOOR_TYPE_FLOOR_GAME,GameJson.class);
    }

    @Autowired
    private AppLayoutDao appLayoutDao;

    @Override
    public int insert(AppLayoutEntity appLayout) {
        return appLayoutDao.insert(appLayout);
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS)
    public Integer updateSkin(Long appId, Long skinId,List<FloorSortJson> floorList) {
        JSONObject floorConfigJson = new JSONObject();
        for(FloorSortJson it:floorList){
            floorConfigJson.put(it.getId().toString(),"{}");
        }
        String array = JSONArray.toJSONString(floorList);
        String floorConfigJsonStr = floorConfigJson.toJSONString();
        appLayoutDao.updateSkinId(appId, skinId);

        appLayoutDao.initFloorConfig(appId,array,floorConfigJsonStr);
        return 1;

    }

    @Override
    public AppLayoutDto buildAppLayoutByAppId(Long appId) {
        AppLayoutEntity entity = appLayoutDao.findByAppId(appId);
        if(Objects.equal(null,entity)){
            return null;
        }

        AppLayoutDto dto = new AppLayoutDto();
        dto.setId(entity.getId());
        dto.setAppId(entity.getAppId());
        dto.setThemeColor(entity.getThemeColor());
        dto.setSkinType(entity.getSkinType());

        switch (entity.getSkinType()){
            case Skin_Type_Old_Theme:
                JSONObject brickIds = JSONObject.parseObject(entity.getBrickIds());
                if(!brickIds.containsKey("0")){
                    dto.setBrickId(1L);
                }else{
                    dto.setBrickId(brickIds.getLong("0"));
                }
                break;
            case Skin_Type_Floor_Skin:
                dto.setSkinId(entity.getSkinId());
                JSONArray array = JSONArray.parseArray(entity.getDevelopSortJson());
                dto.setDevelopSortJson(array);//[{id:楼层Id,floorType:楼层类型,enable:是否展示}]
                String config = entity.getDevelopDataShowJson();
                JSONObject configJson = JSONObject.parseObject(config);
                Map<Long,JSONObject> configMap = Maps.newHashMap();
                for(String key : configJson.keySet()){
                    configMap.put(Long.valueOf(key),JSONObject.parseObject(configJson.getString(key)));
                }
                dto.setDevelopDataShowJson(configMap);
                break;
            default:log.error("出现未知皮肤类型"); throw new RuntimeException("出现未知皮肤类型");
        }
        return dto;
    }
    
    @Override
    public Integer updateDevFloorConfigByAppId(Long appId,Map<Long,JSONObject> jsonMap){
        String config = JSONObject.toJSONString(jsonMap);
        return appLayoutDao.updateDevelopDataShowJsonByAppId(appId,config);
    }

    @Override
    public Integer updateDevSortJsonByAppId(Long appId, JSONArray sortJson) {
        try{
            if(sortJson==null || sortJson.isEmpty()){
                throw new BusinessException("传入楼层排序配置异常");
            }
            List<FloorSortJson> sortlist = Lists.newArrayList();
            for(int i = 0;i<sortJson.size();i++){
                JSONObject json = sortJson.getJSONObject(i);
                FloorSortJson item = new FloorSortJson();
                BeanUtils.populate(item,json);
                ValidatorTool.valid(item);//检验传参合法性
                sortlist.add(item);
            }
            return appLayoutDao.updateDevelopSortJsonByAppId(appId,JSONObject.toJSONString(sortlist));
        }catch(Exception e){
            log.error("更新楼层排序配置失败",e);
            return 0;
        }
    }

    @Override
    public Integer useSkinCount(Long skinId) {
        return appLayoutDao.useSkinCount(skinId);
    }

    @Override
    public Collection<Long> useSkinAppIds(Long skinId) {
        return appLayoutDao.useSkinAppIds(skinId);
    }

    @Override
    public void updateThemeColor(Long appId, String color) {
        appLayoutDao.updateColor(appId,color);
    }

    @Override
    public Class<? extends BaseJson> getBaseJson(Integer floorType) {
        if(floorJsonMap.containsKey(floorType)){
            return floorJsonMap.get(floorType);
        }else{
            return BaseJson.class;
        }
    }

}
