package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorCodeCopyDao;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeCopyService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.*;

/**
 * Created by suyuanlong on 16/8/17.
 */
@Service
public class CreditsFloorCodeCopyServiceImpl implements CreditsFloorCodeCopyService {

    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private CreditsFloorCodeCopyDao creditsFloorCodeCopyDao;

    @PostConstruct
    public void init(){
        eventBus.register(this);
    }

    @Override
    public int insertFloorCodeCopyList(List<CreditsFloorCodeCopyDto> dtoList) {
        return creditsFloorCodeCopyDao.insertFloorCodeCopyList(dtoList);
    }
    @Override
    public int deleteFloorCodeCopyList(Long skinId,Collection<Long> floorIds) {
        if (floorIds.isEmpty()) return 0;
        return creditsFloorCodeCopyDao.deleteFloorCodeCopyList(skinId,floorIds);
    }

    @Override
    public List<CreditsFloorCodeCopyDto> seletListBySkinId(Long skinId) {
        Set<Long> set = Sets.newHashSet(skinId);
        return seletListBySkinIds(set);
    }

    @Override
    public int updateFloorCodeCopy(CreditsFloorCodeCopyDto update) {
        return creditsFloorCodeCopyDao.updateFloorCodeCopy(update);
    }

    @Override
    public List<CreditsFloorCodeCopyDto> seletListBySkinIds(Collection<Long> skinIds) {
        if(skinIds.isEmpty()) return Collections.emptyList();
        return creditsFloorCodeCopyDao.seletListBySkinIds(skinIds);
    }

}
