package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import java.util.List;

import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorShowcaseDao;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorShowcaseService;

@Service
public class CreditsFloorShowcasServiceImpl implements CreditsFloorShowcaseService{
	@Autowired
	CreditsFloorShowcaseDao creditsFloorShowcaseDao;
	
	@Override
	public FloorShowcaseContentDto getShowcaseContent(long appId, int place) {
		return creditsFloorShowcaseDao.selectShowcaseContent(appId, place);
	}

	@Override
	public List<FloorShowcaseContentDto> getShowcaseList(long appId) {
		return creditsFloorShowcaseDao.selectShowcaseList(appId);
	}

	@Override
	public void saveShowcaseConfig(ShowcaseEntity showcaseEntity) {
		creditsFloorShowcaseDao.saveShowcaseConfig(showcaseEntity);
	}

	@Override
	public void delShowcaseConfig(Long appId, Integer place) {
		creditsFloorShowcaseDao.delShowcaseConfig(appId,place);
	}

	@Override
	public void updateShowcaseConfig(ShowcaseEntity showcaseEntity) {
		creditsFloorShowcaseDao.updateShowcaseConfig(showcaseEntity);
	}

	@Override
	public FloorShowcaseContentDto getShowcaseContentIgnoreStatus(long appId, int place) {
		return creditsFloorShowcaseDao.getShowcaseContentIgnoreStatus(appId,place);
	}
}
