package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.developer.ExpressTemplateDao;
import cn.com.duiba.developer.center.biz.entity.AmbExpressTemplateEntity;
import cn.com.duiba.developer.center.biz.service.credits.ExpressTemplateService;

@Service
public class ExpressTemplateServiceImpl implements ExpressTemplateService{
	@Autowired
	private ExpressTemplateDao expressTemplateDAO;

	@Override
	public AmbExpressTemplateEntity find(Long id) {
		return expressTemplateDAO.select(id);
	}

	@Override
	public void insert(AmbExpressTemplateEntity entity) {
		expressTemplateDAO.insert(entity);
	}

	@Override
	public int update(AmbExpressTemplateEntity entity) {
		return expressTemplateDAO.update(entity);
	}

	@Override
	public List<AmbExpressTemplateEntity> findPageList(
			Map<String, Object> params) {
		return expressTemplateDAO.selectPageList(params);
	}

	@Override
	public long findPageCount(Map<String, Object> params) {
		return expressTemplateDAO.selectPageCount(params);
	}

	@Override
	public void deleteTemplateById(Long id) {
		expressTemplateDAO.deleteTemplateById(id);
	}

	@Override
	public List<AmbExpressTemplateEntity> findByAppIdAndType(Long appId,
			String type) {
		return expressTemplateDAO.selectByAppIdAndType(appId, type);
	}

	@Override
	public AmbExpressTemplateEntity findByAppIdAndName(Long appId, String name) {
		return expressTemplateDAO.selectByAppIdAndName(appId, name);
	}

}
