package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.developer.PhoneBillListsDao;
import cn.com.duiba.developer.center.biz.entity.PhonebillListEntity;
import cn.com.duiba.developer.center.biz.service.credits.PhoneBillListsService;

@Service
public class PhoneBillListsServiceimpl implements PhoneBillListsService{
	@Autowired
	private PhoneBillListsDao phoneBillListsDao;
	
	@Override
	public List<PhonebillListEntity> findByMobileAndFacePrice(String mobile,
			Integer facePrice) {
		return phoneBillListsDao.selectByMobileAndFacePrice(mobile, facePrice);
	}

	@Override
	public List<PhonebillListEntity> findAllInFacePrice(List<Integer> facePrices) {
		return phoneBillListsDao.selectAllInFacePrice(facePrices);
	}

	@Override
	public PhonebillListEntity findByFacePriceAndMobile(Integer price,
			String mobile) {
		return phoneBillListsDao.selectByFacePriceAndMobile(price, mobile);
	}

	@Override
	public List<PhonebillListEntity> findAll() {
		return phoneBillListsDao.selectAll();
	}

	@Override
	public void delete(Long id) {
		phoneBillListsDao.delete(id);
	}

	@Override
	public void insert(PhonebillListEntity PhonebillListEntity) {
		phoneBillListsDao.insert(PhonebillListEntity);
	}

	@Override
	public void update(PhonebillListEntity PhonebillListEntity) {
		phoneBillListsDao.update(PhonebillListEntity);
	}

	@Override
	public PhonebillListEntity find(Long id) {
		return phoneBillListsDao.select(id);
	}

}
