package cn.com.duiba.developer.center.biz.service.manager.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.internalletter.InternalLetterKeyDao;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 16/7/19.
 */
@Service
public class InternalLetterKeyServiceImpl implements InternalLetterKeyService {
    private static final Logger log= LoggerFactory.getLogger(InternalLetterKeyServiceImpl.class);
    @Autowired
    private InternalLetterKeyDao internalLetterKeyDao;

    @Override
    public List<InternalLetterKeyDO> findPage(PageQueryEntity param) {
        return internalLetterKeyDao.findPage(param);
    }

    @Override
    public Long findPageCount(PageQueryEntity param) {
        return internalLetterKeyDao.findPageCount(param);
    }

    @Override
    public int batchDelete(Long letterId) {
        return internalLetterKeyDao.batchDelete(letterId);
    }

    @Override
    public int deleteOne(Long letterId,Long developerId) {
        return internalLetterKeyDao.deleteOne(letterId,developerId);
    }

    @Override
    public int batchInsert(InternalLetterDO letter, List<Long> developerIds) {
        return internalLetterKeyDao.batchInsert(letter,developerIds);
    }

    @Override
    public int updateAllReaded(Long developerId) {
        return internalLetterKeyDao.updateAllReaded(developerId);
    }
    @Override
    public int updateOneReaded(Long letterId,Long developerId){
        return internalLetterKeyDao.updateOneReaded(letterId,developerId);
    }

    @Override
    public int getNoRead(Long developerId) {
        Integer count = 0;
        try {
            count = internalLetterKeyDao.findNoReadCount(developerId);
        }catch (Exception e){
            log.error("查找未读站内信条数出错",e);
        }
        return count;

    }
}
