package cn.com.duiba.developer.center.common.tools;

import cn.com.duiba.service.exception.BusinessException;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.*;

/**
 * Created by liuyao on 16/7/18.
 */
public class ValidatorTool{

    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public static <T>List<String> getValidatorErrorList(T pojo){
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<T>> errorSet = validator.validate(pojo);
        if(errorSet.isEmpty()){
            return Collections.emptyList();
        }else{
            List<String> list = Lists.newLinkedList();
            Iterator<ConstraintViolation<T>> it = errorSet.iterator();
            while(it.hasNext()){
                list.add(it.next().getMessage());
            }
            return list;
        }
    }

    public static <T>void valid(T pojo) throws BusinessException {
        List<String> errorList = getValidatorErrorList(pojo);
        if(errorList.isEmpty()) return;
        throw new BusinessException(errorList.get(0));
    }

}
