package cn.com.duiba.developer.center.common.support;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import javax.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by liuyao on 16/7/19.
 */
@Component
public class ThreadPoolDuibaService{
    public static final int PriorityHigh=10;
    public static final int PriorityNormal=5;
    public static final int PriorityLow=1;

    private static final Logger log= LoggerFactory.getLogger(ThreadPoolDuibaService.class);

    /**
     * 线程池最大线程数
     */
    private static final int PoolMaxThread=20;

    private final PriorityBlockingQueue<Runnable> workQueue = new PriorityBlockingQueue<Runnable>();
    private ThreadPoolExecutor pool;

    @PostConstruct
    public void init(){
        if(Objects.equals(null,pool)){
            pool =  new ThreadPoolExecutor(PoolMaxThread, PoolMaxThread,0L,TimeUnit.SECONDS, workQueue);;
        }
        System.out.println("业务线程池初始化完毕");
    }
    /**
     * 提交兑吧任务
     * @param runnable
     * @param priority
     */
    public void submit(Runnable runnable,int priority){
        pool.execute(new DuibaRunnable(runnable, priority));
    }

    public JSONObject dumpDetail(){
        JSONObject o=new JSONObject();
        o.put("runningStat", getRunningStat());
        o.put("waitRunStat", getWaitRunStat());
        return o;
    }

    public int dumpSize(){
        return getRunningStat()+getWaitRunStat();
    }

    public boolean isBusy(){
        int size=dumpSize();
        if(size>100){
            return true;
        }
        return false;
    }


    public class DuibaRunnable implements Runnable,Comparable<DuibaRunnable>{
        private int priority;
        private Runnable runnable;
        public DuibaRunnable(Runnable runnable,int priority){
            Assert.notNull(runnable);
            this.runnable=runnable;
            this.priority=priority;
        }

        @Override
        public void run() {
            runnable.run();
        }

        @Override
        public int compareTo(DuibaRunnable o) {
            if (this.getPriority() < o.getPriority()) {
                return 1;
            }
            if (this.getPriority() > o.getPriority()) {
                return -1;
            }
            return 0;
        }

        public int getPriority() {
            return priority;
        }

    }

    public Integer getRunningStat() {
        return pool.getActiveCount();
    }
    public Integer getWaitRunStat() {
        return pool.getQueue().size();
    }
}
