/**
 * Project Name:developer-center-common
 * File Name:AppLogUtil.java
 * Package Name:cn.com.duiba.developer.center.common.tools
 * Date:2016年8月10日下午10:39:31
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.common.tools;

import org.slf4j.Logger;

/**
 * ClassName:AppLogUtil <br/>
 * 应用系统日志工具类
 * Date:     2016年8月10日 下午10:39:31 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public final class AppLogUtil {
    /**
     * 生成<font color="blue">通知</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger  日志打印对象
     * @param desc    日志描述信息
     */
    public static void info(Logger logger, String desc) {
        info(logger, desc, null, null);
    }

    /**
     * 生成<font color="blue">通知</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger  日志打印对象
     * @param format 日志的格式
     * @param obj     任意个要输出到日志的参数[可空]
     */
    public static void info(Logger logger, String format, Object... obj) {
        if (logger.isInfoEnabled()) {
            logger.info(format, obj);
        }
    }

    /**
     * 生成<font color="brown">警告</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger  日志打印对象
     * @param desc    日志描述信息
     */
    public static void warn(Logger logger, String desc) {
        warn(logger, desc, null, null);
    }

    /**
     * 生成<font color="brown">警告</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger  日志打印对象
     * @param format 
     * @param obj     任意个要输出到日志的参数，异常请放在最后一位[可空]
     */
    public static void warn(Logger logger, String format, Object... obj) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, obj);
        }
    }

    /**
     * 生成<font color="red">错误</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger    日志打印对象
     * @param desc      日志描述信息
     */
    public static void error(Logger logger, String desc) {
        error(logger, desc, null, null);
    }

    /**
     * 生成<font color="red">错误</font>级别日志。<br>
     *
     * <p>可处理任意多个输入参数，并避免在日志级别不够时字符串拼接带来的资源浪费。
     *
     * @param logger    日志打印对象
     * @param format      日志描述信息
     * @param obj       任意个要输出到日志的参数，异常请放在最后一位[可空]
     */
    public static void error(Logger logger, String format, Object... obj) {
        logger.error(format, obj);
    }
}

