package cn.com.duiba.developer.center.common.tools;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;

import javax.mail.internet.MimeMessage;

/**
 * Created by liuyao on 16/8/11.
 */
@Service
public class EmailService {

    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private ThreadPoolDuibaService threadPool;

    public void sendEmail(String to, String subject, String text,boolean html) throws Exception {
        MimeMessage mail = javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(to); // 发送给谁
        helper.setSubject(subject); // 标题
        helper.setFrom("system@duiba.com.cn"); // 来自
        // 邮件内容，第二个参数指定发送的是HTML格式
        helper.setText(text,html);
        javaMailSender.send(mail);
    }

    public void sendEmail(List<String> to, String subject, String text, boolean html) throws Exception {
        sendEmail(to.toArray(new String[to.size()]), subject, text,html);
    }

    public void sendEmail(String[] to, String subject, String text,boolean html) throws Exception {
        MimeMessage mail = javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(to); // 发送给谁
        helper.setSubject(subject); // 标题
        helper.setFrom("system@duiba.com.cn"); // 来自
        // 邮件内容，第二个参数指定发送的是HTML格式
        helper.setText(text,html);
        javaMailSender.send(mail);

    }

    public void sendEmailBcc(List<String> to, String subject, String text,boolean html) throws Exception {
        MimeMessage mail = javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setBcc(to.toArray(new String[to.size()])); // 发送给谁
        helper.setSubject(subject); // 标题
        helper.setFrom("system@duiba.com.cn"); // 来自
        // 邮件内容，第二个参数指定发送的是HTML格式
        helper.setText(text,html);
        javaMailSender.send(mail);
    }

}
