/**
 * Project Name:developer-center-common
 * File Name:JsonUtils.java
 * Package Name:cn.com.duiba.developer.center.common.tools
 * Date:2016年8月19日下午3:45:29
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.common.tools;

import java.io.IOException;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * ClassName:JsonUtils <br/>
 * json解析工具 <br/>
 * Date:     2016年8月19日 下午3:45:29 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class JsonUtils {

    public static ObjectMapper mapper     = new ObjectMapper();
    public static String       jsonString = null;
    
    static {
        //创建输出非空属性到Json字符串的Mapper.
        mapper.setSerializationInclusion(Include.NON_NULL);
    }

    /**
     * 如果对象为Null, 返回"null". 如果集合为空集合, 返回"[]".
     * 
     * @param obj
     * @return
     */
    public static String objectToString(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 如果JSON字符串为Null或"null"字符串, 返回Null. 如果JSON字符串为"[]", 返回空集合.
     * 
     * @param clazz
     * @param json
     * @return
     */
    public static <T> T jsonToObject(Class<T> clazz, String json) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return mapper.readValue(json, clazz);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 
     * json转复杂对象类型用TypeReference构造
     *
     * @author zhanglihui
     * @param json
     * @param typeReference
     * @return
     * @since JDK 1.6
     */
    public static <T> T parseJsonToObject(String json, TypeReference<T> typeReference) {
        T result = null;
        try {
            result = mapper.readValue(json, typeReference);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

}

