/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.common.tools;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ClassUtil {
    public static <T> List<Class<T>> getAllClassByInterface(Class<T> c) {
        ArrayList returnClassList = Lists.newArrayList();
        if (c.isInterface()) {
            String packageName = c.getPackage().getName();
            try {
                List<Class> allClass = ClassUtil.getClasses(packageName);
                for (int i = 0; i < allClass.size(); ++i) {
                    if (!c.isAssignableFrom(allClass.get(i)) || c.equals(allClass.get(i))) continue;
                    returnClassList.add(allClass.get(i));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return returnClassList;
    }

    private static List<Class> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(ClassUtil.findClass(directory, packageName));
        }
        return classes;
    }

    private static List<Class> findClass(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassUtil.findClass(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

