/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.firefly;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.FireflyProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.FireFlyReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.FireFlyResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert.FireflyReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert.FireflyRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class FireflyDspInvoker
extends AbstractDspCaller<FireFlyResp, FireFlyReq> {
    private static final Logger log = LoggerFactory.getLogger(FireflyDspInvoker.class);
    @Autowired
    private FireflyReqConvert fireflyReqConvert;
    @Autowired
    private FireflyRespConvert fireflyRespConvert;
    @Autowired
    private FireflyProperties fireflyProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected FireFlyResp invokeDsp(FireFlyReq fireFlyReq) {
        if (fireFlyReq == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u8424\u706b\u866bDSP\u8c03\u7528");
        try {
            return (FireFlyResp)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.fireflyProperties.getUrl(), fireFlyReq), (String)"invokeDSP", (String)"firefly");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u8424\u706b\u866b_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u8424\u706b\u866b\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private FireFlyResp doHttpInvoke(String url, FireFlyReq fireFlyReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        long timestamp = System.currentTimeMillis() / 1000L;
        headers.add("ff-timestamp", timestamp + "");
        String sign = this.sign(timestamp);
        headers.add("ff-authorization", "10027:" + sign);
        HttpEntity requestEntity = new HttpEntity((Object)fireFlyReq, (MultiValueMap)headers);
        ResponseEntity resEntity = null;
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, FireFlyResp.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("\u8424\u706b\u866b\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
            return null;
        }
        FireFlyResp body = (FireFlyResp)resEntity.getBody();
        SamplerLog.info((String)"\u8424\u706b\u866b response is {}", (Object[])new Object[]{body});
        if (body == null || body.getNbr() != 0) {
            return null;
        }
        Cat.logMetricForCount((String)"\u8424\u706b\u866bDSP\u8fd4\u56de");
        return body;
    }

    private String sign(long timestamp) {
        int accountId = 10027;
        String data = String.format("%d_%d_%s", timestamp, accountId, this.fireflyProperties.getSecret());
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_14.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_14;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        url = url.replace("${__AUCTION_PRICE__}", price);
        return url;
    }

    @Override
    public FireFlyReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.fireflyReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(FireFlyResp fireFlyResp) throws DspException {
        return this.fireflyRespConvert.convert(fireFlyResp);
    }
}

