/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.IqiyiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.PriceEncrypterUtils;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert.IqiyiReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert.IqiyiRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class IqiyiDspInvoker
extends AbstractDspCaller<IqiyiBid.BidResponse, IqiyiBid.BidRequest> {
    private static final Logger log = LoggerFactory.getLogger(IqiyiDspInvoker.class);
    @Autowired
    private IqiyiReqConvert iqiyiReqConvert;
    @Autowired
    private IqiyiRespConvert iqiyiRespConvert;
    @Resource
    IqiyiProperties iqiyiProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected IqiyiBid.BidResponse invokeDsp(IqiyiBid.BidRequest iqiyiReq) {
        if (Objects.isNull(iqiyiReq)) {
            return null;
        }
        Cat.logMetricForCount((String)"\u7231\u5947\u827aDSP\u8c03\u7528");
        try {
            return (IqiyiBid.BidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.iqiyiProperties.getUrl(), iqiyiReq), (String)"invokeDSP", (String)"iqiyi");
        }
        catch (ResourceAccessException e) {
            log.warn("\u7231\u5947\u827a DSP,http\u8bf7\u6c42\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("\u7231\u5947\u827a DSP\u8bf7\u6c42\u5931\u8d25,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            log.error("\u7231\u5947\u827a\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IqiyiBid.BidResponse doHttpInvoke(String url, IqiyiBid.BidRequest bidRequest) throws IOException {
        ResponseEntity resEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        HttpEntity requestEntity = new HttpEntity((Object)bidRequest.toByteArray(), (MultiValueMap)headers);
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u7231\u5947\u827a\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        IqiyiBid.BidResponse body = IqiyiBid.BidResponse.parseFrom(resource.getInputStream());
        Transaction transaction = Cat.newTransaction((String)"invokeDSP", (String)"kuaishouReturn");
        transaction.setStatus("-1");
        HttpStatus statusCode = resEntity.getStatusCode();
        try {
            if (statusCode.is2xxSuccessful()) {
                if (HttpStatus.OK.value() == statusCode.value()) {
                    Cat.logMetricForCount((String)"\u7231\u5947\u827aDSP\u8fd4\u56de");
                    transaction.setStatus("0");
                    IqiyiBid.BidResponse bidResponse = body;
                    return bidResponse;
                }
                SamplerLog.info((String)"\u7231\u5947\u827aDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object[])new Object[]{bidRequest, body});
                Cat.logMetricForCount((String)"\u7231\u5947\u827aDSP\u8fd4\u56de2xx");
                IqiyiBid.BidResponse bidResponse = null;
                return bidResponse;
            }
            if (statusCode.is5xxServerError()) {
                Cat.logMetricForCount((String)"\u7231\u5947\u827aDSP\u8fd4\u56de5xx");
                SamplerLog.info((String)"\u7231\u5947\u827aDSP\u8fd4\u56de5xx,iqiyiRequest[{}],body[{}]", (Object[])new Object[]{bidRequest, body});
                IqiyiBid.BidResponse bidResponse = null;
                return bidResponse;
            }
            Cat.logMetricForCount((String)"\u7231\u5947\u827aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801");
            SamplerLog.info((String)"\u7231\u5947\u827aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,iqiyiRequest[{}],body[{}]", (Object[])new Object[]{bidRequest, body});
            IqiyiBid.BidResponse bidResponse = null;
            return bidResponse;
        }
        finally {
            transaction.complete();
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            return PriceEncrypterUtils.encryptPrice(price.intValue(), this.iqiyiProperties.getInitializeVector().getBytes(StandardCharsets.UTF_8), this.iqiyiProperties.getEncryptionToken().getBytes(StandardCharsets.UTF_8), this.iqiyiProperties.getIntegrityToken().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("\u7231\u5947\u827a\u4ef7\u683c\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_16.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_16;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        url = url.replace("${__AUCTION_PRICE__}", price);
        return url;
    }

    @Override
    public IqiyiBid.BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.iqiyiReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(IqiyiBid.BidResponse bidResponse) throws DspException {
        return this.iqiyiRespConvert.respConvert(bidResponse);
    }
}

