/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import com.google.protobuf.GeneratedMessageV3;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class IqiyiReqConvert {
    @Resource
    private AppReplace appReplace;

    public IqiyiBid.BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        IqiyiBid.BidRequest.Builder bidRequest = IqiyiBid.BidRequest.newBuilder();
        bidRequest.setId(adxCommonBidRequest.getRequestId());
        bidRequest.setTimestamp((int)System.currentTimeMillis());
        IqiyiBid.BidRequest.Imp imp = this.impConvert(adxCommonBidRequest, dspInfo);
        bidRequest.addImp(imp);
        bidRequest.setResourcetype(adxCommonBidRequest.getAppInfo() != null ? 1 : 0);
        if (bidRequest.getResourcetype() == 0) {
            bidRequest.setSite(IqiyiBid.BidRequest.Site.newBuilder().build());
        } else {
            IqiyiBid.BidRequest.App app = this.appConvert(adxCommonBidRequest.getAppInfo(), dspInfo);
            bidRequest.setApp(app);
        }
        IqiyiBid.BidRequest.Device device = this.deviceConvert(adxCommonBidRequest);
        bidRequest.setDevice(device);
        IqiyiBid.BidRequest.User user = this.userConvert(adxCommonBidRequest);
        bidRequest.setUser(user);
        bidRequest.setTest(false);
        bidRequest.addDeduplicatedIds(IqiyiBid.BidRequest.DeduplicatedId.newBuilder().build());
        return bidRequest.build();
    }

    private IqiyiBid.BidRequest.Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        GeneratedMessageV3 video;
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        IqiyiBid.BidRequest.Imp.Builder imp = IqiyiBid.BidRequest.Imp.newBuilder();
        imp.setAdzoneId(commonImp.getTagId());
        imp.setAdType(IqiyiBid.BidRequest.Imp.AdType.forNumber(Integer.parseInt(dspInfo.getDspResId())));
        if (commonImp.getFilteringSize().get(0).getType() == 3) {
            video = this.videoConvert(commonImp);
            imp.setVideo((IqiyiBid.BidRequest.Imp.Video)video);
        } else {
            video = this.nativeConvert(commonImp);
        }
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidfloor((int)floorPrice);
        return imp.build();
    }

    private IqiyiBid.BidRequest.Imp.Video videoConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Video.Builder video = IqiyiBid.BidRequest.Imp.Video.newBuilder();
        video.setLinearity(IqiyiBid.BidRequest.Imp.Video.VideoLinearity.LINEAR);
        video.setAcceptedCreativeTypes(2);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        video.setW(commonSizeInfo.getWidth());
        video.setH(commonSizeInfo.getHeight());
        video.setMinduration(commonSizeInfo.getMinduration());
        video.setMaxduration(commonSizeInfo.getMaxduration());
        video.setStartdelay(0);
        video.setMaxadscount(1);
        video.setFormat(IqiyiBid.BidRequest.Imp.VideoFormat.VIDEO_MP4);
        return video.build();
    }

    private IqiyiBid.BidRequest.Imp.Native nativeConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Native.Builder nativeAd = IqiyiBid.BidRequest.Imp.Native.newBuilder();
        nativeAd.setTitleLen(100);
        ArrayList imgs = new ArrayList();
        IqiyiBid.BidRequest.Imp.Native.Image.Builder image2 = IqiyiBid.BidRequest.Imp.Native.Image.newBuilder();
        image2.setType(IqiyiBid.BidRequest.Imp.Native.Image.ImageAssetType.MAIN);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        image2.setW(commonSizeInfo.getWidth());
        image2.setH(commonSizeInfo.getHeight());
        nativeAd.addImgs(image2);
        nativeAd.setMaxadscount(1);
        return nativeAd.build();
    }

    private IqiyiBid.BidRequest.App appConvert(CommonAppInfo appInfo, DspInfo dspInfo) {
        IqiyiBid.BidRequest.App.Builder app = IqiyiBid.BidRequest.App.newBuilder();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
        } else {
            app.setBundle(appInfo.getBundle());
        }
        app.setName(StringUtils.isNotEmpty((CharSequence)appInfo.getName()) ? appInfo.getName() : "");
        app.setVer(appInfo.getVersion());
        app.setKeywords(StringUtils.isNotEmpty((CharSequence)appInfo.getKeywords()) ? appInfo.getKeywords() : "");
        return app.build();
    }

    private IqiyiBid.BidRequest.Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        IqiyiBid.BidRequest.Device.Builder device = IqiyiBid.BidRequest.Device.newBuilder();
        String ip = commonDevice.getIp();
        if (ip.contains(":")) {
            device.setIp(ip);
        } else {
            device.setIp(ip);
        }
        device.setUa(commonDevice.getUa());
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        } else if ("2".equals(carrier)) {
            device.setCarrier(2);
        } else if ("3".equals(carrier)) {
            device.setCarrier(3);
        } else {
            device.setCarrier(4);
        }
        Integer connectionType = commonDevice.getTuiaConnectionType();
        if (connectionType == 2) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.WIFI);
        } else if (connectionType == 4) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_2G);
        } else if (connectionType == 5) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_3G);
        } else if (connectionType == 6) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_4G);
        } else if (connectionType == 7) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_5G);
        } else {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_UNKNOWN);
        }
        device.setDevicetype(IqiyiBid.BidRequest.Device.DeviceType.UNKNOWN_DEVICE);
        device.setOsv(commonDevice.getOsVersion());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        IqiyiBid.BidRequest.Geo geo = this.geoConvert(commonDevice.getGeo());
        device.setGeo(geo);
        return device.build();
    }

    private IqiyiBid.BidRequest.Geo geoConvert(CommonGeo commonGeo) {
        IqiyiBid.BidRequest.Geo.Builder geo = IqiyiBid.BidRequest.Geo.newBuilder();
        if (commonGeo != null && commonGeo.getLat() != null && commonGeo.getLon() != null) {
            geo.setLat(commonGeo.getLat().floatValue());
            geo.setLon(commonGeo.getLon().floatValue());
            geo.setType(IqiyiBid.BidRequest.Geo.LocationType.IP);
        }
        return geo.build();
    }

    private IqiyiBid.BidRequest.User userConvert(AdxCommonBidRequest adxCommonBidRequest) {
        IqiyiBid.BidRequest.User.Builder user = IqiyiBid.BidRequest.User.newBuilder();
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (StringUtils.isNotEmpty((CharSequence)userInfo.getId()) && Objects.nonNull(userInfo.getId())) {
            user.setId(user.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)userInfo.getGender()) && Objects.nonNull(userInfo.getGender())) {
            user.setGender(userInfo.getGender());
        }
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(Integer.parseInt(String.valueOf(LocalDate.now().getYear() - yop))));
        if (StringUtils.isNotEmpty((CharSequence)userInfo.getKeywords()) && Objects.nonNull(userInfo.getKeywords())) {
            user.setKeywords(userInfo.getKeywords());
        }
        return user.build();
    }
}

