/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IqiyiRespConvert {
    private static final Logger log = LoggerFactory.getLogger(IqiyiRespConvert.class);

    public AdxCommonBidResponse respConvert(IqiyiBid.BidResponse response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_16.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getBidList());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<IqiyiBid.BidResponse.Bid> bidList) {
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        for (IqiyiBid.BidResponse.Bid bid : bidList) {
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext context = new CommonContext();
            commonSeatBid.setCommonContext(context);
            CommonCreative commonCreative = new CommonCreative();
            commonSeatBid.setCommonCreative(commonCreative);
            if (!Objects.nonNull(bid)) continue;
            commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
            commonSeatBid.setAdvertiserId("");
            IqiyiBid.BidResponse.Bid.Link link = bid.getLink();
            commonSeatBid.setWinCallbackUrls(Collections.emptyList());
            commonCreative.setLandingPageUrl(link.getCurl());
            commonCreative.setCreativeId(bid.getCrid());
            commonCreative.setDeepLinkUrl(link.getDeeplink());
            context.setDeepLinkUrl(link.getDeeplink());
            commonSeatBid.setExposureCallbackUrls(Collections.singletonList(link.getImptrackers(0)));
            commonSeatBid.setClickCallbackUrls(Collections.singletonList(link.getClicktrackers(0)));
            this.processAdmContent(bid, commonCreative);
        }
        return commonSeatBidList;
    }

    private void processAdmContent(IqiyiBid.BidResponse.Bid bid, CommonCreative commonCreative) {
        this.processNativeContent(bid.getAdmnative(), commonCreative);
        this.processVideoContent(bid.getAdmvideo(), commonCreative);
    }

    private void processNativeContent(IqiyiBid.BidResponse.Bid.AdmNative admNative, CommonCreative commonCreative) {
        if (StringUtils.isNotEmpty((CharSequence)admNative.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admNative.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (CollectionUtils.isNotEmpty(admNative.getImgsList())) {
            ArrayList<CommonImage> imageList = new ArrayList<CommonImage>();
            for (IqiyiBid.BidResponse.Bid.Image img : admNative.getImgsList()) {
                CommonImage image2 = new CommonImage();
                image2.setUrl(img.getUrl());
                image2.setWidth(img.getW());
                image2.setHeight(img.getH());
                imageList.add(image2);
            }
            commonCreative.setCommonImageList(imageList);
        }
        ArrayList<CommonVideo> videoList = new ArrayList<CommonVideo>();
        IqiyiBid.BidResponse.Bid.Video video = admNative.getVideo();
        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(video.getUrl());
        commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
        commonVideo.setCoverUrl(video.getStartCover());
        videoList.add(commonVideo);
        commonCreative.setCommonVideoList(videoList);
        if (Objects.isNull(commonCreative.getCommonTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle("\u60ca\u559c");
            commonCreative.setCommonTitle(commonTitle);
        }
    }

    private void processVideoContent(IqiyiBid.BidResponse.Bid.AdmVideo admVideo, CommonCreative commonCreative) {
        if (StringUtils.isNotEmpty((CharSequence)admVideo.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admVideo.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (CollectionUtils.isNotEmpty(admVideo.getImgsList())) {
            ArrayList<CommonImage> imageList = new ArrayList<CommonImage>();
            for (IqiyiBid.BidResponse.Bid.Image img : admVideo.getImgsList()) {
                CommonImage image2 = new CommonImage();
                image2.setUrl(img.getUrl());
                image2.setWidth(img.getW());
                image2.setHeight(img.getH());
                imageList.add(image2);
            }
            commonCreative.setCommonImageList(imageList);
        }
        ArrayList<CommonVideo> videoList = new ArrayList<CommonVideo>();
        IqiyiBid.BidResponse.Bid.Video video = admVideo.getVideo();
        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(video.getUrl());
        commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
        commonVideo.setCoverUrl(video.getStartCover());
        videoList.add(commonVideo);
        commonCreative.setCommonVideoList(videoList);
        if (Objects.isNull(commonCreative.getCommonTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle("\u60ca\u559c");
            commonCreative.setCommonTitle(commonTitle);
        }
    }
}

