/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.AdInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.AppRsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.JuMeiResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Track;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class JuMeiRespConvert {
    public AdxCommonBidResponse convert(JuMeiResp juMeiResp) {
        List<AdInfo> data = juMeiResp.getData();
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_15.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatBidConvert(data);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<AdInfo> data) {
        AdInfo adInfo = data.get(0);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        if (StringUtils.isNotBlank((CharSequence)adInfo.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adInfo.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adInfo.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adInfo.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        commonCreative.setDeepLinkUrl(adInfo.getDeeplink());
        context.setDeepLinkUrl(adInfo.getDeeplink());
        commonCreative.setULinkUrl(adInfo.getUniversalLink());
        context.setULinkUrl(adInfo.getUniversalLink());
        commonCreative.setLandingPageUrl(adInfo.getLandingPageUrl());
        commonSeatBid.setPrice(adInfo.getBidPrice().doubleValue());
        commonSeatBid.setWinCallbackUrls(adInfo.getWinNoticeUrls());
        if (adInfo.getApp() != null) {
            AppRsp app = adInfo.getApp();
            commonCreative.setAppName(app.getName());
            commonCreative.setAppBundle(app.getPkgName());
            commonCreative.setIconUrl(app.getIconUrl());
        }
        if (adInfo.getVideo() != null) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            CommonVideo commonVideo = new CommonVideo();
            Video video = adInfo.getVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setCoverUrl(video.getCoverUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            if (video.getDuration() != null) {
                commonVideo.setDuration(new BigDecimal(video.getDuration()));
            }
            commonVideo.setSize(video.getSize());
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            List<Image> images = adInfo.getImages();
            for (Image image2 : images) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getWidth());
                commonImage.setHeight(image2.getHeight());
                commonImageList.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImageList);
        }
        Track track = adInfo.getTrack();
        List<String> showUrls = track.getShowUrls();
        commonSeatBid.setExposureCallbackUrls(showUrls);
        commonSeatBid.setClickCallbackUrls(track.getClickUrls());
        return commonSeatBidList;
    }
}

