/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.Adm;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.SeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QiHangJsonRespConvert {
    private static final Logger log = LoggerFactory.getLogger(QiHangJsonRespConvert.class);

    public AdxCommonBidResponse convert(QiHangResp bidResponse) {
        if (bidResponse == null) {
            return null;
        }
        List<SeatBid> seat_bid = bidResponse.getSeat_bid();
        if (CollectionUtils.isEmpty(seat_bid)) {
            return null;
        }
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_10.getDspId());
        SeatBid seatBid = seat_bid.get(0);
        Bid bid = seatBid.getBid().get(0);
        CommonSeatBid commonSeatBid = this.bidConvert(bid);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        response.setUserScoreLevel(bid.getUser_score_level());
        return response;
    }

    private CommonSeatBid bidConvert(Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        commonSeatBid.setPriceType(bid.getBid_type());
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        commonSeatBid.setExposureCallbackUrls(bid.getImp_trackers());
        commonSeatBid.setClickCallbackUrls(bid.getClk_trackers());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setAppName(bid.getApp_name());
        String bundle = bid.getPackage_name();
        if (StringUtils.isBlank((CharSequence)bundle)) {
            bundle = "com.taobao.taobao";
        }
        commonCreative.setAppBundle(bundle);
        commonCreative.setIconUrl(bid.getIcon_url());
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(bid.getIcon_url());
        commonCreative.setCommonIcon(commonIcon);
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank((CharSequence)adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.getVideo() != null) {
            Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideo_url());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(adm.getCover_img_url());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<Image> imageList = adm.getImage();
            ArrayList<CommonImage> commonImages = new ArrayList<CommonImage>(imageList.size());
            for (Image image2 : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getWidth());
                commonImage.setHeight(image2.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDeep_link())) {
            commonCreative.setDeepLinkUrl(adm.getDeep_link());
            context.setDeepLinkUrl(adm.getDeep_link());
            String dspTaskId = this.getDspTaskId(adm.getDeep_link());
            commonCreative.setDspTaskId(dspTaskId);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getUniversal_link())) {
            commonCreative.setULinkUrl(adm.getUniversal_link());
            context.setULinkUrl(adm.getUniversal_link());
        }
        commonCreative.setLandingPageUrl(adm.getLanding_site());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }

    private String getDspTaskId(String deepLinkUrl) {
        try {
            deepLinkUrl = URLDecoder.decode(deepLinkUrl, "UTF-8");
            if (deepLinkUrl.contains("bc_fl_src")) {
                String[] params;
                for (String param : params = deepLinkUrl.split("&")) {
                    String[] keyValue;
                    if (!param.startsWith("bc_fl_src") || (keyValue = param.split("=")).length != 2) continue;
                    return keyValue[1].split("-")[2];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

