/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class TanxDspInvoker
extends AbstractDspCaller<TanxBiddingResponse.Response, TanxBiddingRequest.Request> {
    private static final Logger log = LoggerFactory.getLogger(TanxDspInvoker.class);
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Autowired
    private TanxRequestConvert tanxRequestConvert;
    @Autowired
    private TanxResponseConvert tanxResponseConvert;
    @Autowired
    private TanxProperties tanxProperties;

    @Override
    protected TanxBiddingResponse.Response invokeDsp(TanxBiddingRequest.Request tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        try {
            return (TanxBiddingResponse.Response)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.tanxProperties.getUrl(), tanxBiddingRequest), (String)"invokeDSP", (String)"tanx");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"tanx_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"tanxDSP\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private TanxBiddingResponse.Response doHttpInvoke(String url, TanxBiddingRequest.Request tanxBiddingRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        HttpEntity requestEntity = new HttpEntity((Object)tanxBiddingRequest.toByteArray(), (MultiValueMap)headers);
        SamplerLog.info((String)"tanx doHttpInvoke rtbRequest:{}", (Object[])new Object[]{tanxBiddingRequest});
        Cat.logMetricForCount((String)"tanxDSP\u8c03\u7528");
        ResponseEntity resEntity = null;
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"tanxDSP\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        TanxBiddingResponse.Response response = TanxBiddingResponse.Response.parseFrom(resource.getInputStream());
        if (CollectionUtils.isNotEmpty(response.getSeatList())) {
            Cat.logMetricForCount((String)"tanxDSP\u8fd4\u56de");
        }
        return response;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            String hexPrice = String.format("%08X", Integer.parseInt(tme));
            byte[] hexBytes = Hex.decodeHex((char[])hexPrice.toCharArray());
            String bidid = DigestUtils.md5Hex((String)this.getAdxRid());
            byte[] bytes3 = Hex.decodeHex((char[])bidid.toCharArray());
            byte[] bytes4 = new byte[bytes3.length + hexBytes.length];
            System.arraycopy(bytes3, 0, bytes4, 0, bytes3.length);
            System.arraycopy(hexBytes, 0, bytes4, bytes3.length, hexBytes.length);
            String token = "9c62ef1eef3d9ff42ebab4f169c8a4ca";
            byte[] bytes1 = Hex.decodeHex((char[])token.toCharArray());
            SecretKeySpec secretKey = new SecretKeySpec(bytes1, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(bytes4);
            tme = Base64.getUrlEncoder().encodeToString(bytes);
            if (tme.contains("=")) {
                tme = tme.replace("=", "");
            }
            return tme;
        }
        catch (Exception e) {
            log.warn("tanx\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    public String int32ToHexStr(int num) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(num);
        byte[] data = buffer.array();
        StringBuilder hexBuilder = new StringBuilder();
        for (byte b : data) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            hexBuilder.append(hex);
        }
        return hexBuilder.toString();
    }

    public String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public String hex2str(String hexStr) {
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < hexStr.length(); i += 2) {
            String hex = hexStr.substring(i, i + 2);
            int decimal = Integer.parseInt(hex, 16);
            encoded.append((char)decimal);
        }
        return encoded.toString();
    }

    public static void main(String[] args) {
        TanxDspInvoker tanxDspInvoker = new TanxDspInvoker();
        tanxDspInvoker.setAdxRid("abc45678901234561234567890123456");
        String s = tanxDspInvoker.priceEncryption(new BigDecimal(1500));
        System.out.println(s);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_5.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_5;
    }

    private int str2hex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public String string2Hex(String str) {
        if (str.length() % 2 != 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i += 2) {
            int high = this.str2hex(str.charAt(i));
            int low = this.str2hex(str.charAt(i + 1));
            int num = high << 4 | low;
            sb.append((char)num);
        }
        return sb.toString();
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__AUCTION_PRICE__") && price != null) {
            url = url.replaceAll("__AUCTION_PRICE__", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public TanxBiddingRequest.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.tanxRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(TanxBiddingResponse.Response tanxBiddingResponse) throws DspException {
        try {
            return this.tanxResponseConvert.respConvert(tanxBiddingResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}

