/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Icon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Video;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TuiaReqConvert {
    @Autowired
    private AppReplace appReplace;

    public BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BidRequest request = new BidRequest();
        request.setId(adxCommonBidRequest.getRequestId());
        Imp imp = this.impConvert(adxCommonBidRequest, dspInfo);
        request.setImp(imp);
        App app = this.appConvert(adxCommonBidRequest, dspInfo);
        request.setApp(app);
        Device device = this.deviceConvert(adxCommonBidRequest, dspInfo);
        request.setDevice(device);
        if (Objects.equals(adxCommonBidRequest.getHttpProtocol(), 1)) {
            request.setSecure(1);
        }
        return request;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        List<Caid> caids;
        Device device = new Device();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDeviceType(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfaMd5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaidMd5(commonDevice.getOaIdMd5());
        device.setImei(commonDevice.getImei());
        device.setImeiMd5(commonDevice.getImeiMd5());
        device.setOs(commonDevice.getOs());
        device.setOsv(commonDevice.getOsVersion());
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getCarrier())) {
            device.setCarrier(Integer.parseInt(commonDevice.getCarrier()));
        }
        if (CollectionUtils.isNotEmpty(caids = commonDevice.getCaids())) {
            for (Caid caid : caids) {
                if (!caid.getVersion().equals("20220111")) continue;
                device.setCaid(caid.getId());
                device.setCaidVersion(caid.getVersion());
            }
        }
        device.setBootMark(commonDevice.getBootTime());
        device.setUpdateMark(commonDevice.getUpdateTime());
        device.setAndroidId(commonDevice.getDpId());
        device.setAndroidIdMd5(commonDevice.getDpIdMd5());
        return device;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setName(appInfo.getName());
            }
            app.setBundle(appInfo.getBundle());
            app.setVersion(appInfo.getVersion());
        }
        return app;
    }

    public Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Imp imp = new Imp();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        imp.setId(1);
        imp.setSlotType(Integer.parseInt(dspInfo.getDspResId()));
        imp.setPid(dspInfo.getDspTagId());
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidFloor((int)floorPrice);
        imp.setBidType(0);
        List<CommonSizeInfo> filteringSize = commonImp.getFilteringSize();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            if (Objects.equals(commonSizeInfo.getType(), 1)) {
                Image image2 = new Image();
                image2.setWidth(commonSizeInfo.getWidth());
                image2.setHeight(commonSizeInfo.getHeight());
                imp.setImage(image2);
            }
            if (!Objects.equals(commonSizeInfo.getType(), 3)) continue;
            Video video = new Video();
            video.setWidth(commonSizeInfo.getWidth());
            video.setHeight(commonSizeInfo.getHeight());
            video.setCoverWidth(commonSizeInfo.getWidth());
            video.setCoverHeight(commonSizeInfo.getHeight());
            imp.setVideo(video);
        }
        Icon icon = new Icon();
        icon.setWidth(100);
        icon.setHeight(100);
        imp.setIcon(icon);
        imp.setNeedTitle(1);
        imp.setMaxTitle(15);
        imp.setNeedDesc(1);
        imp.setMaxDesc(30);
        return imp;
    }
}

