/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.filter.AdvertConditionFilter;
import cn.com.tuia.advert.adxService.AdxEngineService;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BudgetConditionFilter
implements AdvertConditionFilter {
    private static final Logger log = LoggerFactory.getLogger(BudgetConditionFilter.class);
    @Resource
    private AdxEngineService adxEngineService;
    AsyncLoadingCache<Long, Optional<Boolean>> budgetValidCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.SECONDS).buildAsync(this::load);

    public Optional<Boolean> load(Long key) {
        try {
            return Optional.ofNullable(this.adxEngineService.outDspBudgetValidInfo(key));
        }
        catch (Exception exception) {
            return Optional.of(Boolean.FALSE);
        }
    }

    @Override
    public boolean match(DspInfo dspInfo) {
        Long advertId = dspInfo.getAdvertId();
        if (Objects.isNull(advertId)) {
            SamplerLog.info((String)"BudgetConditionFilter.match advertId is null", (Object[])new Object[0]);
            return false;
        }
        try {
            Boolean validate = ((Optional)this.budgetValidCache.get((Object)advertId).get()).orElse(false);
            if (!validate.booleanValue()) {
                SamplerLog.info((String)"BudgetConditionFilter \u5e7f\u544a\u5df2\u7ecf\u5931\u6548advertId:{}", (Object[])new Object[]{advertId});
            }
            return validate;
        }
        catch (Exception e) {
            SamplerLog.warn((String)"BudgetConditionFilter error, dspInfo:{}", (Object[])new Object[]{JSON.toJSONString((Object)dspInfo), e});
            return false;
        }
    }
}

