/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloseableHttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseableHttpClientUtil.class);
    @Resource
    private CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGet(String url) {
        HttpGet request = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(500).setSocketTimeout(500).build();
        request.setConfig(requestConfig);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.warn("CloseableHttpClientUtil.doGet error url is {}", (Object)url, (Object)e);
        }
        finally {
            request.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPost(String url, Map<String, Object> params) {
        HttpPost request = new HttpPost();
        try {
            Throwable throwable;
            CloseableHttpResponse response;
            block21: {
                request.setURI(new URI(url));
                request.setHeader("Content-Type", "application/json; charset=utf-8");
                StringEntity s = new StringEntity(JSON.toJSONString(params));
                request.setEntity((HttpEntity)s);
                try {
                    String string;
                    block22: {
                        response = this.httpClient.execute((HttpUriRequest)request);
                        throwable = null;
                        try {
                            String res;
                            int code = response.getStatusLine().getStatusCode();
                            if (code != 200) break block21;
                            string = res = EntityUtils.toString((HttpEntity)response.getEntity());
                            if (response == null) return string;
                            if (throwable == null) break block22;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (response == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        response.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                response.close();
                                throw throwable5;
                            }
                        }
                        try {
                            response.close();
                            return string;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return string;
                        }
                    }
                    response.close();
                    return string;
                }
                catch (Exception ex) {
                    LOGGER.warn("doPost error", (Throwable)ex);
                    return null;
                }
            }
            if (response == null) return null;
            if (throwable == null) {
                response.close();
                return null;
            }
            try {
                response.close();
                return null;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("doPost error", (Throwable)ex);
            return null;
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String url, JSONObject json) {
        HttpPost post = new HttpPost(url);
        try {
            StringEntity s = new StringEntity(json.toString());
            s.setContentEncoding("UTF-8");
            s.setContentType("application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)s);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    String string = EntityUtils.toString((HttpEntity)response.getEntity());
                    return string;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("CloseableHttpClientUtil.doPost error", (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }
}

