/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RgyunResponseConverter {
    public AdxCommonBidResponse respConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_4.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        commonSeatBid.setAdvertiserId("44910");
        commonSeatBid.setPrice(StringUtils.isBlank((CharSequence)rtbResponse.getPrice()) ? 0.0 : Double.parseDouble(rtbResponse.getPrice()));
        commonSeatBid.setCommonCreative(this.creativeConvert(rtbResponse));
        commonSeatBid.setWinCallbackUrl(rtbResponse.getNurl());
        commonSeatBid.setExposureCallbackUrl(this.getExposureUrl(rtbResponse.getPvList()));
        commonSeatBid.setClickCallbackUrl(this.getClickUrl(rtbResponse.getClickList()));
        commonSeatBid.setCommonContext(this.commonContextConvert(rtbResponse));
        return commonSeatBidList;
    }

    private String getClickUrl(List<RgyunBiddingResponse.RTBResponse.Click> clickList) {
        if (CollectionUtils.isEmpty(clickList)) {
            return null;
        }
        return clickList.get(0).getUrl();
    }

    private String getExposureUrl(List<RgyunBiddingResponse.RTBResponse.Pv> pvList) {
        if (CollectionUtils.isEmpty(pvList)) {
            return null;
        }
        return pvList.get(0).getUrl();
    }

    private CommonContext commonContextConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        CommonContext commonContext = new CommonContext();
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        if (!RgyunBiddingResponse.RTBResponse.AdType.AT_Call.equals((Object)adtype)) {
            return commonContext;
        }
        commonContext.setDeepLinkUrl(rtbResponse.getDplurl());
        commonContext.setULinkUrl(rtbResponse.getJumpurl());
        return commonContext;
    }

    private CommonCreative creativeConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        CommonCreative commonCreative = new CommonCreative();
        this.setLandPageUrlByAdType(rtbResponse, commonCreative);
        commonCreative.setBrandName("\u63a8\u554a");
        commonCreative.setCommonTitle(this.convertCommonTitle(rtbResponse.getTitle(), rtbResponse.getDesc()));
        commonCreative.setCommonDesc(this.commonDescConvert(rtbResponse.getDesc()));
        commonCreative.setCommonIcon(this.commonIconConvert(rtbResponse.getIconurl()));
        this.commonImageOrVideoConvert(rtbResponse, commonCreative);
        commonCreative.setAppName(rtbResponse.getApkname());
        commonCreative.setAppBundle(rtbResponse.getPackage());
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        if (RgyunBiddingResponse.RTBResponse.AdType.AT_AppDownload.equals((Object)adtype)) {
            commonCreative.setDownloadUrl(rtbResponse.getTarget());
            commonCreative.setPrivacyPolicyLink(rtbResponse.getPrivacylink());
            commonCreative.setPermissionLink(rtbResponse.getPermissionlink());
            commonCreative.setAppVersion(rtbResponse.getAppversion());
            commonCreative.setDeveloper(rtbResponse.getDeveloper());
        }
        Optional.of(rtbResponse.getIconurl()).ifPresent(o -> commonCreative.setIconUrl((String)o));
        return commonCreative;
    }

    private void setLandPageUrlByAdType(RgyunBiddingResponse.RTBResponse rtbResponse, CommonCreative commonCreative) {
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        if (adtype == null) {
            return;
        }
        switch (adtype) {
            case AT_Normal: {
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                break;
            }
            case AT_AppDownload: {
                break;
            }
            case AT_Call: {
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                commonCreative.setDeepLinkUrl(rtbResponse.getDplurl());
                commonCreative.setULinkUrl(rtbResponse.getJumpurl());
                break;
            }
            case AT_Action: {
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                break;
            }
            default: {
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
            }
        }
    }

    private void commonImageOrVideoConvert(RgyunBiddingResponse.RTBResponse rtbResponse, CommonCreative commonCreative) {
        RgyunBiddingResponse.RTBResponse.MaterialType materialtype = rtbResponse.getMaterialtype();
        if (RgyunBiddingResponse.RTBResponse.MaterialType.MT_Image.equals((Object)materialtype)) {
            commonCreative.setCommonImageList(this.convertCommImage(rtbResponse));
        }
        if (RgyunBiddingResponse.RTBResponse.MaterialType.MT_Video.equals((Object)materialtype)) {
            commonCreative.setCommonVideoList(this.convertCommVideo(rtbResponse));
        }
    }

    private List<CommonVideo> convertCommVideo(RgyunBiddingResponse.RTBResponse rtbResponse) {
        ProtocolStringList adurlsList = rtbResponse.getAdurlsList();
        if (CollectionUtils.isEmpty((Collection)adurlsList)) {
            return null;
        }
        ArrayList commonVideoList = Lists.newArrayList();
        adurlsList.forEach(url -> {
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl((String)url);
            commonVideo.setResolutionY(rtbResponse.getHeight());
            commonVideo.setResolutionX(rtbResponse.getWidth());
            commonVideo.setCoverUrl(rtbResponse.getCoverimg());
            commonVideo.setDuration(new BigDecimal(rtbResponse.getDuration()));
            commonVideoList.add(commonVideo);
        });
        return commonVideoList;
    }

    private List<CommonImage> convertCommImage(RgyunBiddingResponse.RTBResponse rtbResponse) {
        ProtocolStringList adurlsList = rtbResponse.getAdurlsList();
        if (CollectionUtils.isEmpty((Collection)adurlsList)) {
            return null;
        }
        ArrayList commonImageList = Lists.newArrayList();
        adurlsList.forEach(url -> {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl((String)url);
            commonImage.setHeight(rtbResponse.getHeight());
            commonImage.setWidth(rtbResponse.getWidth());
            commonImageList.add(commonImage);
        });
        return commonImageList;
    }

    private CommonIcon commonIconConvert(String iconurl) {
        if (StringUtils.isBlank((CharSequence)iconurl)) {
            return null;
        }
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconurl);
        return commonIcon;
    }

    private CommonDesc commonDescConvert(String desc) {
        CommonDesc commonDesc = new CommonDesc();
        commonDesc.setDesc(desc);
        return commonDesc;
    }

    private CommonTitle convertCommonTitle(String title, String desc) {
        CommonTitle commonTitle = new CommonTitle();
        commonTitle.setTitle(title);
        commonTitle.setSubTitle(desc);
        return commonTitle;
    }
}

