/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.filter.AdvertConditionFilter;
import cn.com.tuia.advert.adxService.AdxEngineService;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BudgetConditionFilter
implements AdvertConditionFilter {
    private static final Logger log = LoggerFactory.getLogger(BudgetConditionFilter.class);
    @Autowired
    private AdxEngineService adxEngineService;

    @Override
    public boolean match(DspInfo dspInfo) {
        Long advertId = dspInfo.getAdvertId();
        if (Objects.isNull(advertId)) {
            log.info("BudgetConditionFilter.match advertId is null");
            return false;
        }
        try {
            Boolean validate = this.adxEngineService.outDspBudgetValidInfo(advertId);
            if (!validate.booleanValue()) {
                log.info("BudgetConditionFilter \u5e7f\u544a\u5df2\u7ecf\u5931\u6548advertId:{}", (Object)advertId);
            }
            return validate;
        }
        catch (Exception e) {
            log.warn("BudgetConditionFilter error, dspInfo:{}", (Object)JSON.toJSONString((Object)dspInfo), (Object)e);
            return false;
        }
    }
}

