package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class TanxResponseConvert {
    public AdxCommonBidResponse respConvert(TanxBiddingResponse.Response response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_5.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getSeatList());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<TanxBiddingResponse.Response.Seat> seatList) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        TanxBiddingResponse.Response.Seat seat = seatList.get(0);
        TanxBiddingResponse.Response.Seat.Ad ad = seat.getAd(0);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        List<CommonImage> imageList = null;
        CommonImage image = new CommonImage();
        List<CommonVideo> videoList = null;
        CommonVideo video = new CommonVideo();
        if (ad.getCreativeType() == 2) {
            imageList = new ArrayList<>();
            imageList.add(image);
            commonCreative.setCommonImageList(imageList);
        }
        if (ad.getCreativeType() == 4) {
            videoList = new ArrayList<>();
            videoList.add(video);
            commonCreative.setCommonVideoList(videoList);
        }
        commonSeatBid.setPrice(Double.parseDouble(String.valueOf(ad.getBidPrice())));
//        commonSeatBid.setAdvertiserId();
        commonSeatBid.setWinCallbackUrl(ad.getWinnoticeUrl());
        commonCreative.setLandingPageUrl(ad.getClickThroughUrl());
        commonCreative.setCreativeId(ad.getCreativeId());
        commonCreative.setDeepLinkUrl(ad.getDeeplinkUrl());
        context.setDeepLinkUrl(ad.getDeeplinkUrl());
        //openType 4表示落地页返回ulink地址
        if (ad.getOpenType() == 4) {
            commonCreative.setULinkUrl(ad.getClickThroughUrl());
            context.setULinkUrl(ad.getClickThroughUrl());
        }
        ProtocolStringList impressionTrackingUrlList = ad.getImpressionTrackingUrlList();
        commonSeatBid.setExposureCallbackUrl(impressionTrackingUrlList.get(0));
        if (impressionTrackingUrlList.size() == 2) {
            commonSeatBid.setExposureCallbackUrl2(impressionTrackingUrlList.get(1));
        }
        ProtocolStringList clickTrackingUrlList = ad.getClickTrackingUrlList();
        commonSeatBid.setClickCallbackUrl(clickTrackingUrlList.get(0));
        if (clickTrackingUrlList.size() == 2) {
            commonSeatBid.setClickCallbackUrl2(clickTrackingUrlList.get(1));
        }
        TanxBiddingResponse.Response.Seat.Ad.NativeAd nativeAd = ad.getNativeAd();
        List<TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr> attrList = nativeAd.getAttrList();
        for (TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr attr : attrList) {
            String name = attr.getName();
            String value = attr.getValue();
            if ("img_url".equals(name)) {
                image.setUrl(value);
            }
            if ("img_width".equals(name)) {
                image.setWidth(Integer.valueOf(value));
            }
            if ("img_height".equals(name)) {
                image.setHeight(Integer.valueOf(value));
            }
            if ("video".equals(name)) {
                video.setVideoUrl(value);
            }
            if ("video_width".equals(name)) {
                video.setResolutionX(Integer.valueOf(value));
            }
            if ("video_height".equals(name)) {
                video.setResolutionY(Integer.valueOf(value));
            }
            if ("video_duration".equals(name)) {
                video.setDuration(new BigDecimal(value));
            }
            if ("title".equals(name)) {
                CommonTitle commonTitle = new CommonTitle();
                commonTitle.setTitle(value);
                commonCreative.setCommonTitle(commonTitle);
            }
        }
        return commonSeatBidList;
    }
}
