/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.BuLuKenProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter.BuLuKenRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter.BuLuKenResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class BuLuKenDspInvoker
extends AbstractDspCaller<BuLuKenBidResponse, BuLuKenBidRequest> {
    private static final Logger log = LoggerFactory.getLogger(BuLuKenDspInvoker.class);
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Autowired
    private BuLuKenRequestConvert buLuKenRequestConvert;
    @Autowired
    private BuLuKenResponseConvert buLuKenResponseConvert;
    @Autowired
    private BuLuKenProperties buLuKenProperties;

    @Override
    protected BuLuKenBidResponse invokeDsp(BuLuKenBidRequest tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u5e03\u9c81\u80af DSP\u8c03\u7528");
        try {
            return (BuLuKenBidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.buLuKenProperties.getUrl(), tanxBiddingRequest), (String)"invokeDSP", (String)"\u5e03\u9c81\u80af");
        }
        catch (ResourceAccessException e) {
            log.warn("\u5e03\u9c81\u80af DSP,http\u8bf7\u6c42\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("\u5e03\u9c81\u80af DSP\u8bf7\u6c42\u5931\u8d25,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            log.error("\u5e03\u9c81\u80af\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", e);
            return null;
        }
    }

    private BuLuKenBidResponse doHttpInvoke(String url, BuLuKenBidRequest request) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, BuLuKenBidResponse.class, new Object[0]);
        HttpStatus statusCode = resEntity.getStatusCode();
        BuLuKenBidResponse body = (BuLuKenBidResponse)resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            }
            log.info("\u5e03\u9c81\u80afDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object)JSONObject.toJSONString((Object)request), (Object)JSONObject.toJSONString((Object)body));
            Cat.logMetricForCount((String)"\u5e03\u9c81\u80afDSP\u8fd4\u56de2xx");
            return null;
        }
        if (statusCode.is5xxServerError()) {
            Cat.logMetricForCount((String)"\u5e03\u9c81\u80afDSP\u8fd4\u56de5xx");
            log.warn("\u5e03\u9c81\u80afDSP\u8fd4\u56de5xx,request[{}],body[{}]", (Object)JSONObject.toJSONString((Object)request), (Object)JSONObject.toJSONString((Object)body));
            return null;
        }
        Cat.logMetricForCount((String)"\u5e03\u9c81\u80afDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801");
        log.warn("\u5e03\u9c81\u80afDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,request[{}],body[{}]", (Object)JSONObject.toJSONString((Object)request), (Object)JSONObject.toJSONString((Object)body));
        return null;
    }

    private BuLuKenBidResponse handle2xx(BuLuKenBidResponse response) {
        return response;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    public static void main(String[] args) {
        TanxDspInvoker invoker = new TanxDspInvoker();
        String s = invoker.priceEncryption(new BigDecimal("10"));
        System.out.println(s);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_6.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_6;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%WINNING_PRICE%%") && price != null) {
            url = url.replaceAll("%%WINNING_PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public BuLuKenBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.buLuKenRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(BuLuKenBidResponse tanxBiddingResponse) throws DspException {
        try {
            return this.buLuKenResponseConvert.respConvert(tanxBiddingResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}

