/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.FilterMaterInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.OsConvert;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BuLuKenRequestConvert {
    private static final Logger log = LoggerFactory.getLogger(BuLuKenRequestConvert.class);
    private static final Integer BANNER_TYPTE = 1;
    private static final Integer VIDEO_TYPE = 3;
    public final String ANDROID = "0";
    public final String IOS = "1";
    public static final String MOVE = "1";
    public static final String UNICOM = "2";
    public static final String TELECOM = "3";

    public BuLuKenBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BuLuKenBidRequest builder = new BuLuKenBidRequest();
        builder.setVersion("2.4");
        builder.setId(adxCommonBidRequest.getRequestId());
        this.convertImp(builder, adxCommonBidRequest, dspInfo);
        this.convertApp(builder, adxCommonBidRequest, dspInfo);
        this.convertDevice(builder, adxCommonBidRequest);
        return builder;
    }

    public void convertImp(BuLuKenBidRequest builder, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BuLuKenBidRequest.Imp imp = new BuLuKenBidRequest.Imp();
        builder.setImp(Collections.singletonList(imp));
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        imp.setId(commonImp.getId());
        imp.setIsdeeplink(true);
        List<CommonSizeInfo> filteringSize = this.filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());
        if (CollectionUtils.isNotEmpty(filteringSize)) {
            CommonSizeInfo commonSizeInfo = filteringSize.get(0);
            if (dspInfo.getDspTagId() != null) {
                imp.setTagid(dspInfo.getDspTagId());
            }
            Integer type = commonSizeInfo.getType();
            Integer pos = null;
            if (StringUtils.isNotBlank((CharSequence)dspInfo.getDspResId())) {
                pos = Integer.valueOf(dspInfo.getDspResId());
            }
            if (BANNER_TYPTE.equals(type)) {
                BuLuKenBidRequest.Banner bannerBuilder = new BuLuKenBidRequest.Banner();
                bannerBuilder.setW(commonSizeInfo.getWidth());
                bannerBuilder.setH(commonSizeInfo.getHeight());
                if (pos != null) {
                    bannerBuilder.setPos(pos);
                }
                imp.setBanner(bannerBuilder);
            } else if (VIDEO_TYPE.equals(type)) {
                BuLuKenBidRequest.Video videoBuilder = new BuLuKenBidRequest.Video();
                videoBuilder.setW(commonSizeInfo.getWidth());
                videoBuilder.setH(commonSizeInfo.getHeight());
                videoBuilder.setType(1);
                videoBuilder.setMimes(Collections.singletonList("video/mp4"));
                videoBuilder.setMinduration(Optional.ofNullable(commonSizeInfo.getMinduration()).orElse(5));
                videoBuilder.setMaxduration(Optional.ofNullable(commonSizeInfo.getMaxduration()).orElse(30));
                imp.setVideo(videoBuilder);
            } else {
                log.warn("\u5e03\u9c81\u80afdsp convertImp \u65e0\u6cd5\u8bc6\u522b\u662fbanner \u8fd8\u662f video");
            }
        }
        imp.setBidfloor(Double.valueOf(Math.round(commonImp.getFloorPrice())));
    }

    public String getOsType(String os) {
        if (StringUtils.isBlank((CharSequence)os)) {
            return "unknown";
        }
        switch (os) {
            case "0": {
                return "Android";
            }
            case "1": {
                return "iOS";
            }
        }
        return "unknown";
    }

    public String getCarrierType(String carrier) {
        if (StringUtils.isBlank((CharSequence)carrier)) {
            return "mobile";
        }
        switch (carrier) {
            case "1": {
                return "mobile";
            }
            case "2": {
                return "unicom";
            }
            case "3": {
                return "telecom";
            }
        }
        return "mobile";
    }

    public void convertDevice(BuLuKenBidRequest request, AdxCommonBidRequest adxCommonBidRequest) {
        BuLuKenBidRequest.Device builder = new BuLuKenBidRequest.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUa(device.getUa());
        if (StringUtils.isNotEmpty((CharSequence)device.getImeiMd5())) {
            builder.setDidmd5(StringUtils.upperCase((String)device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaIdMd5())) {
            builder.setOidmd5(StringUtils.upperCase((String)device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getIdFaMd5())) {
            builder.setIfamd5(StringUtils.upperCase((String)device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaId())) {
            builder.setOid(device.getOaId());
        }
        builder.setDevicetype(0);
        builder.setMake(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setCarrier(this.getCarrierType(device.getCarrier()));
        builder.setConnectiontype(device.getTuiaConnectionType());
        request.setDevice(builder);
    }

    public void convertApp(BuLuKenBidRequest request, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BuLuKenBidRequest.App builder = new BuLuKenBidRequest.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        builder.setBundle(appInfo.getBundle());
        builder.setName(appInfo.getName());
        builder.setVersion(appInfo.getVersion());
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        ArrayList commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = this.matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (!Objects.nonNull(commonSizeInfo1)) continue;
            commonSizeInfos.add(commonSizeInfo1);
        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (!filterMaterInfo.getWidth().equals(width) || !filterMaterInfo.getHeight().equals(height)) continue;
            return commonSizeInfo;
        }
        return null;
    }
}

