/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BuLuKenResponseConvert {
    private static final Logger log = LoggerFactory.getLogger(BuLuKenResponseConvert.class);

    public AdxCommonBidResponse respConvert(BuLuKenBidResponse response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_5.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getSeatbid().getBid());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<BuLuKenBidResponse.Bid> seatList) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        BuLuKenBidResponse.Bid bid = seatList.get(0);
        if (Objects.nonNull(bid)) {
            BuLuKenBidResponse.Admobject admobject;
            commonSeatBid.setPrice((double)bid.getPrice());
            commonSeatBid.setAdvertiserId("");
            commonSeatBid.setWinCallbackUrls(Collections.singletonList(bid.getNurl()));
            commonCreative.setCreativeId(bid.getId());
            commonCreative.setDeepLinkUrl(bid.getDeeplink());
            context.setDeepLinkUrl(bid.getDeeplink());
            BuLuKenBidResponse.Events events = bid.getEvents();
            if (Objects.nonNull(events)) {
                commonSeatBid.setExposureCallbackUrls(events.getImp_urls());
                commonSeatBid.setClickCallbackUrls(events.getClick_urls());
            }
            if (Objects.nonNull(admobject = bid.getAdmobject()) && Objects.nonNull(admobject.getNativeObj()) && CollectionUtils.isNotEmpty(admobject.getNativeObj().getAssets())) {
                BuLuKenBidResponse.Asset asset = admobject.getNativeObj().getAssets().get(0);
                if (Objects.nonNull(asset.getImg())) {
                    ArrayList<CommonImage> imageList = new ArrayList<CommonImage>();
                    CommonImage image = new CommonImage();
                    image.setUrl(asset.getImg().getUrl());
                    image.setWidth(asset.getImg().getW());
                    image.setHeight(asset.getImg().getH());
                    imageList.add(image);
                    commonCreative.setCommonImageList(imageList);
                }
                if (Objects.nonNull(asset.getVideo())) {
                    ArrayList<CommonVideo> videoList = new ArrayList<CommonVideo>();
                    CommonVideo video = new CommonVideo();
                    video.setVideoUrl(asset.getVideo().getUrl());
                    video.setDuration(BigDecimal.valueOf(asset.getVideo().getDuration().intValue()));
                    video.setCoverUrl(asset.getVideo().getCover());
                    videoList.add(video);
                    commonCreative.setCommonVideoList(videoList);
                }
            }
        }
        return commonSeatBidList;
    }
}

