package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class BuLuKenBidResponse {
    private String id;
    private String bidid;
    private Seatbid seatbid;
    @lombok.Data
    public static class Seatbid {
        private List<Bid> bid;
    }
    @lombok.Data
    public static class Bid {
        private String id;
        private String impid;
        private Integer price;
        private Admobject admobject;
        private String nurl;
        private String clickurl;
        private String deeplink;
        private Integer action;
        private App app;
        private Events events;
        private String target;
    }
    @lombok.Data
    public static class Admobject {
        @JsonProperty("native")
        private Native nativeObj;
        private Video video;

    }
    @lombok.Data
    public static class Native {
        private List<Asset> assets;
    }
    @lombok.Data
    public static class Asset {
        private Integer id;
        private Integer isrequired;
        private Title title;
        private Img img;
        private Video video;
        private Data data;
        @lombok.Data
        public static class Video {
            private String url;
            private Integer duration;
            private String cover;
        }
    }
    @lombok.Data
    public static class Title {
        private String text;
    }
    @lombok.Data
    public static class Img {
        private String url;
        private Integer w;
        private Integer h;
        private Integer type;
    }


    @lombok.Data
    public static class Data {
        private String label;
        private String value;
    }
    @lombok.Data
    public static class Video {
        private Integer w;
        private Integer h;
        private Integer type;
        private Integer size;
        private List<String> mimes;
        private String url;
        private Integer duration;
        private String cover;
        private Integer skip;
        private Integer skip_mintime;
        private Integer pre_load_ttl;
        private Card card;
    }
    @lombok.Data
    public static class Card {
        private Integer type;
        private String url;
        private String html;
        private String charset;
        private String icon;
        private String title;
        private String content;
        private Integer comments;
        private Integer rating;
        private Button button;
    }
    @lombok.Data
    public static class Button {
        private String url;
        private String text;
    }
    @lombok.Data
    public static class App {
        private Integer size;
        private String md5;
        private String icon;

        @JsonProperty("package")
        private String packageName;
        private Integer version_code;
        private String version;
        private String name;
        private String publisher;
        private String privacy_link;
        private String permission_link;
        private String app_desc;
    }
    @lombok.Data
    public static class Events {
        private List<String> imp_urls;
        private List<String> click_urls;
        private List<String> start_dod_urls;
        private List<String> finish_dod_urls;
        private List<String> start_install_urls;
        private List<String> finish_install_urls;
        private List<String> active_urls;
        private List<String> start_play_urls;
        private List<String> start_25play_urls;
        private List<String> start_50play_urls;
        private List<String> start_75play_urls;
        private List<String> pause_play_urls;
        private List<String> replay_urls;
        private List<String> finish_play_urls;
        private List<String> deeplink_urls;
        private List<String> deeplink_furls;
        private List<String> step_play_urls;
        private List<String> mute_play_urls;
        private List<String> skip_play_urls;
        private List<String> close_play_urls;
    }
}
